/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=13)
public class TransientMortalCacheEntry
extends AbstractInternalCacheEntry {
    private TransientMortalCacheValue cacheValue;

    TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, System.currentTimeMillis(), lifespan, maxIdle);
        this.touch();
    }

    TransientMortalCacheEntry(Object key, Object value) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, System.currentTimeMillis());
        this.touch();
    }

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, created, lifespan, maxIdle, lastUsed);
    }

    public InternalCacheEntry setLifespan(long lifespan) {
        if (lifespan < 0L) {
            return new TransientCacheEntry(this.key, this.cacheValue.value, this.cacheValue.lastUsed, this.cacheValue.maxIdle);
        }
        this.cacheValue.lifespan = lifespan;
        return this;
    }

    public InternalCacheEntry setMaxIdle(long maxIdle) {
        if (maxIdle < 0L) {
            return new MortalCacheEntry(this.key, this.cacheValue.value, this.cacheValue.lifespan, this.cacheValue.created);
        }
        this.cacheValue.maxIdle = maxIdle;
        return this;
    }

    public Object getValue() {
        return this.cacheValue.value;
    }

    public long getLifespan() {
        return this.cacheValue.lifespan;
    }

    public final boolean canExpire() {
        return true;
    }

    public long getCreated() {
        return this.cacheValue.created;
    }

    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    public final long getExpiryTime() {
        return this.cacheValue.lifespan > -1L ? this.cacheValue.created + this.cacheValue.lifespan : -1L;
    }

    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    public long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    public final void touch() {
        this.cacheValue.lastUsed = System.currentTimeMillis();
    }

    public long getMaxIdle() {
        return this.cacheValue.maxIdle;
    }

    public Object setValue(Object value) {
        return this.cacheValue.maxIdle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientMortalCacheEntry that = (TransientMortalCacheEntry)o;
        if (this.cacheValue.created != that.cacheValue.created) {
            return false;
        }
        return this.cacheValue.lifespan == that.cacheValue.lifespan;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.cacheValue.created ^ this.cacheValue.created >>> 32);
        result = 31 * result + (int)(this.cacheValue.lifespan ^ this.cacheValue.lifespan >>> 32);
        return result;
    }

    public TransientMortalCacheEntry clone() {
        TransientMortalCacheEntry clone = (TransientMortalCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "cacheValue=" + this.cacheValue + "} " + super.toString();
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            TransientMortalCacheEntry ice = (TransientMortalCacheEntry)subject;
            output.writeObject(ice.key);
            output.writeObject(((TransientMortalCacheEntry)ice).cacheValue.value);
            UnsignedNumeric.writeUnsignedLong(output, ((TransientMortalCacheEntry)ice).cacheValue.created);
            output.writeLong(((TransientMortalCacheEntry)ice).cacheValue.lifespan);
            UnsignedNumeric.writeUnsignedLong(output, ((TransientMortalCacheEntry)ice).cacheValue.lastUsed);
            output.writeLong(((TransientMortalCacheEntry)ice).cacheValue.maxIdle);
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientMortalCacheEntry(k, v, maxIdle, lifespan, lastUsed, created);
        }
    }
}

