/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.distribution.AbstractConsistentHash;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Marshallable(externalizer=Externalizer.class, id=51)
public class DefaultConsistentHash
extends AbstractConsistentHash {
    ArrayList<Address> addresses;
    SortedMap<Integer, Address> positions;
    static final int HASH_SPACE = 10240;

    @Override
    public void setCaches(List<Address> caches) {
        this.addresses = new ArrayList<Address>(caches);
        this.addresses.trimToSize();
        this.positions = new TreeMap<Integer, Address>();
        for (Address a : this.addresses) {
            int positionIndex = Math.abs(a.hashCode()) % 10240;
            while (this.positions.containsKey(positionIndex)) {
                ++positionIndex;
            }
            this.positions.put(positionIndex, a);
        }
        this.addresses.clear();
        for (Address a : this.positions.values()) {
            this.addresses.add(a);
        }
    }

    @Override
    public List<Address> getCaches() {
        return this.addresses;
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        int hash = Math.abs(key.hashCode());
        int clusterSize = this.addresses.size();
        int numCopiesToFind = Math.min(replCount, clusterSize);
        ArrayList<Address> owners = new ArrayList<Address>(numCopiesToFind);
        SortedMap<Integer, Address> candidates = this.positions.tailMap(hash % 10240);
        for (Address a : candidates.values()) {
            if (owners.size() >= numCopiesToFind) break;
            owners.add(a);
        }
        if (owners.size() < numCopiesToFind) {
            for (Address a : this.positions.values()) {
                if (owners.size() >= numCopiesToFind) break;
                owners.add(a);
            }
        }
        return owners;
    }

    @Override
    public int getDistance(Address a1, Address a2) {
        if (a1 == null || a2 == null) {
            throw new NullPointerException("Cannot deal with nulls as parameters!");
        }
        int p1 = this.addresses.indexOf(a1);
        if (p1 < 0) {
            throw new IllegalArgumentException("Address " + a1 + " not in the addresses list of this consistent hash impl!");
        }
        int p2 = this.addresses.indexOf(a2);
        if (p2 < 0) {
            throw new IllegalArgumentException("Address " + a2 + " not in the addresses list of this consistent hash impl!");
        }
        if (p1 <= p2) {
            return p2 - p1;
        }
        return this.addresses.size() - (p1 - p2);
    }

    @Override
    public boolean isAdjacent(Address a1, Address a2) {
        int distance = this.getDistance(a1, a2);
        return distance == 1 || distance == this.addresses.size() - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        return !(this.positions != null ? !this.positions.equals(that.positions) : that.positions != null);
    }

    public int hashCode() {
        int result = this.addresses != null ? this.addresses.hashCode() : 0;
        result = 31 * result + (this.positions != null ? this.positions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultConsistentHash{addresses (in order of hash space position)=" + this.positions.values() + '}';
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            DefaultConsistentHash dch = (DefaultConsistentHash)subject;
            output.writeObject(dch.addresses);
            output.writeObject(dch.positions);
        }

        public Object readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            DefaultConsistentHash dch = new DefaultConsistentHash();
            dch.addresses = (ArrayList)unmarshaller.readObject();
            dch.positions = (SortedMap)unmarshaller.readObject();
            return dch;
        }
    }
}

