/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.ConsistentHashHelper;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.RehashTask;
import org.infinispan.distribution.StateMap;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.loaders.CacheStore;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaveTask
extends RehashTask {
    private static final Log log = LogFactory.getLog(LeaveTask.class);
    private final List<Address> leavers;
    private final Address self;
    private final List<Address> leaversHandled;

    protected LeaveTask(DistributionManagerImpl dmi, RpcManager rpcManager, Configuration configuration, List<Address> leavers, TransactionLogger transactionLogger, CommandsFactory cf, DataContainer dataContainer) {
        super(dmi, rpcManager, configuration, transactionLogger, cf, dataContainer);
        this.leavers = leavers;
        this.leaversHandled = new LinkedList<Address>(leavers);
        this.self = rpcManager.getTransport().getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRehash() throws Exception {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Commencing.  Leavers' list is {0}", this.leavers);
        }
        boolean completedSuccessfully = false;
        LinkedList<Address> leaversHandled = new LinkedList<Address>(this.leavers);
        ConsistentHash oldCH = ConsistentHashHelper.createConsistentHash(this.configuration, this.dmi.getConsistentHash().getCaches(), leaversHandled);
        int replCount = this.configuration.getNumOwners();
        try {
            StateMap statemap = new StateMap(leaversHandled, this.self, oldCH, this.dmi.getConsistentHash(), replCount);
            if (log.isTraceEnabled()) {
                log.trace("Examining state in data container");
            }
            for (InternalCacheEntry ice : this.dataContainer) {
                List<Address> oldOwners = oldCH.locate(ice.getKey(), replCount);
                for (Address a : oldOwners) {
                    if (!leaversHandled.contains(a)) continue;
                    statemap.addState(ice);
                }
            }
            CacheStore cs = this.dmi.getCacheStoreForRehashing();
            if (cs != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Examining state in cache store");
                }
                for (InternalCacheEntry ice : cs.loadAll()) {
                    if (statemap.containsKey(ice.getKey())) continue;
                    statemap.addState(ice);
                }
            }
            HashSet<NotifyingFutureImpl> pushFutures = new HashSet<NotifyingFutureImpl>();
            for (Map.Entry<Address, Map<Object, InternalCacheValue>> entry : statemap.getState().entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Pushing {0} entries to {1}", entry.getValue().size(), entry.getKey());
                }
                RehashControlCommand push = this.cf.buildRehashControlCommand(RehashControlCommand.Type.PUSH_STATE, this.self, entry.getValue());
                NotifyingFutureImpl f = new NotifyingFutureImpl(null);
                pushFutures.add(f);
                this.rpcManager.invokeRemotelyInFuture(Collections.singleton(entry.getKey()), push, true, f, this.configuration.getRehashRpcTimeout());
            }
            for (Future future : pushFutures) {
                future.get();
            }
            completedSuccessfully = true;
            this.invalidateInvalidHolders(oldCH, this.dmi.getConsistentHash());
            if (log.isInfoEnabled()) {
                log.info((Object)"Completed in {0}!", Util.prettyPrintTime(System.currentTimeMillis() - start));
            }
        }
        catch (InterruptedException ie) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Interrupted after {0}!  Completed successfully? {1}", Util.prettyPrintTime(System.currentTimeMillis() - start), completedSuccessfully);
            }
        }
        catch (Exception e) {
            log.error((Object)"Caught exception! Completed successfully? {0}", e, completedSuccessfully);
        }
        finally {
            if (completedSuccessfully) {
                this.leavers.removeAll(leaversHandled);
            }
        }
    }

    @Override
    protected Collection<Address> getInvalidHolders(Object key, ConsistentHash chOld, ConsistentHash chNew) {
        Collection<Address> l = super.getInvalidHolders(key, chOld, chNew);
        l.removeAll(this.leaversHandled);
        return l;
    }
}

