/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.remoting.transport.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StateMap {
    List<Address> leavers;
    Address self;
    ConsistentHash oldCH;
    ConsistentHash newCH;
    int replCount;
    Set<Object> keysHandled = new HashSet<Object>();
    Map<Address, Map<Object, InternalCacheValue>> state = new HashMap<Address, Map<Object, InternalCacheValue>>();

    StateMap(List<Address> leavers, Address self, ConsistentHash oldCH, ConsistentHash newCH, int replCount) {
        this.leavers = leavers;
        this.self = self;
        this.oldCH = oldCH;
        this.newCH = newCH;
        this.replCount = replCount;
    }

    void addState(InternalCacheEntry ice) {
        for (Address leaver : this.leavers) {
            boolean isLeaverLast;
            List<Address> owners = this.oldCH.locate(ice.getKey(), this.replCount);
            int leaverIndex = owners.indexOf(leaver);
            if (leaverIndex <= -1) continue;
            int numOwners = owners.size();
            int selfIndex = owners.indexOf(this.self);
            boolean bl = isLeaverLast = leaverIndex == numOwners - 1;
            if ((!isLeaverLast || selfIndex != numOwners - 2) && (isLeaverLast || selfIndex != leaverIndex + 1)) continue;
            List<Address> newOwners = this.newCH.locate(ice.getKey(), this.replCount);
            newOwners.removeAll(owners);
            if (newOwners.isEmpty()) continue;
            for (Address no : newOwners) {
                Map<Object, InternalCacheValue> s = this.state.get(no);
                if (s == null) {
                    s = new HashMap<Object, InternalCacheValue>();
                    this.state.put(no, s);
                }
                s.put(ice.getKey(), ice.toInternalCacheValue());
            }
        }
        this.keysHandled.add(ice.getKey());
    }

    Map<Address, Map<Object, InternalCacheValue>> getState() {
        return this.state;
    }

    boolean containsKey(Object key) {
        return this.keysHandled.contains(key);
    }
}

