/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.util.TypedProperties;

public class DefaultExecutorFactory
implements ExecutorFactory {
    private static final AtomicInteger counter = new AtomicInteger(0);

    public ExecutorService getExecutor(Properties p) {
        TypedProperties tp = TypedProperties.toTypedProperties(p);
        int maxThreads = tp.getIntProperty("maxThreads", 1);
        int queueSize = tp.getIntProperty("queueSize", 100000);
        final String threadNamePrefix = tp.getProperty("threadNamePrefix", "Thread");
        ThreadFactory tf = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, threadNamePrefix + "-" + counter.getAndIncrement());
                th.setDaemon(true);
                return th;
            }
        };
        return new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), tf);
    }
}

