/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.loaders.AbstractCacheLoader;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.Marshaller;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheStore
extends AbstractCacheLoader
implements CacheStore {
    private final Map<GlobalTransaction, List<? extends Modification>> transactions = new ConcurrentHashMap<GlobalTransaction, List<? extends Modification>>();
    private static Log log = LogFactory.getLog(AbstractCacheStore.class);
    private AbstractCacheStoreConfig config;
    private ExecutorService purgerService;
    protected Marshaller marshaller;

    @Override
    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) throws CacheLoaderException {
        this.config = (AbstractCacheStoreConfig)config;
        this.marshaller = m;
        if (config == null) {
            throw new IllegalStateException("Null config!!!");
        }
    }

    @Override
    public void start() throws CacheLoaderException {
        if (this.config == null) {
            throw new IllegalStateException("Make sure you call super.init() from CacheStore extension");
        }
        this.purgerService = this.config.isPurgeSynchronously() ? new WithinThreadExecutor() : Executors.newSingleThreadExecutor();
    }

    @Override
    public void stop() throws CacheLoaderException {
        this.purgerService.shutdownNow();
    }

    @Override
    public void purgeExpired() throws CacheLoaderException {
        if (this.purgerService == null) {
            throw new IllegalStateException("PurgeService is null (did you call super.start() from cache loader implementation ?");
        }
        this.purgerService.execute(new Runnable(){

            public void run() {
                try {
                    AbstractCacheStore.this.purgeInternal();
                }
                catch (CacheLoaderException e) {
                    log.error((Object)"Problems encountered while purging expired", e);
                }
            }
        });
    }

    protected void purgeInternal() throws CacheLoaderException {
    }

    protected void applyModifications(List<? extends Modification> mods) throws CacheLoaderException {
        block5: for (Modification modification : mods) {
            switch (modification.getType()) {
                case STORE: {
                    Store s = (Store)modification;
                    this.store(s.getStoredEntry());
                    continue block5;
                }
                case CLEAR: {
                    this.clear();
                    continue block5;
                }
                case REMOVE: {
                    Remove r = (Remove)modification;
                    this.remove(r.getKey());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown modification type " + (Object)((Object)modification.getType()));
        }
    }

    @Override
    public void prepare(List<? extends Modification> mods, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            this.applyModifications(mods);
        } else {
            this.transactions.put(tx, mods);
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        this.transactions.remove(tx);
    }

    @Override
    public CacheStoreConfig getCacheStoreConfig() {
        return this.config;
    }

    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        List<? extends Modification> list = this.transactions.remove(tx);
        if (list != null && !list.isEmpty()) {
            this.applyModifications(list);
        }
    }

    @Override
    public void removeAll(Set<Object> keys) throws CacheLoaderException {
        if (keys != null && !keys.isEmpty()) {
            for (Object key : keys) {
                this.remove(key);
            }
        }
    }

    protected final void safeClose(InputStream stream) throws CacheLoaderException {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            throw new CacheLoaderException("Problems closing input stream", e);
        }
    }

    protected final void safeClose(OutputStream stream) throws CacheLoaderException {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            throw new CacheLoaderException("Problems closing output stream", e);
        }
    }

    protected Marshaller getMarshaller() {
        return this.marshaller;
    }
}

