/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.loaders.AbstractCacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.util.Util;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"singletonStore", "async"})
public class AbstractCacheStoreConfig
extends AbstractCacheLoaderConfig
implements CacheStoreConfig {
    @XmlAttribute
    private Boolean ignoreModifications = false;
    @XmlAttribute
    private Boolean fetchPersistentState = false;
    @XmlAttribute
    private Boolean purgeOnStartup = false;
    @XmlAttribute
    private Boolean purgeSynchronously = false;
    @XmlElement
    private SingletonStoreConfig singletonStore = new SingletonStoreConfig();
    @XmlElement
    private AsyncStoreConfig async = new AsyncStoreConfig();

    public boolean isPurgeSynchronously() {
        return this.purgeSynchronously;
    }

    public void setPurgeSynchronously(boolean purgeSynchronously) {
        this.testImmutability("purgeSynchronously");
        this.purgeSynchronously = purgeSynchronously;
    }

    public boolean isPurgeOnStartup() {
        return this.purgeOnStartup;
    }

    public boolean isFetchPersistentState() {
        return this.fetchPersistentState;
    }

    @ConfigurationAttribute(name="fetchPersistentState", containingElement="loader", description="If true, fetch persistent state on state transfer")
    public void setFetchPersistentState(boolean fetchPersistentState) {
        this.testImmutability("fetchPersistentState");
        this.fetchPersistentState = fetchPersistentState;
    }

    @ConfigurationAttribute(name="ignoreModifications", containingElement="loader", description="If true, any operation that modifies the cache store (remove, clear, store...etc) won't be applied to it")
    public void setIgnoreModifications(boolean ignoreModifications) {
        this.testImmutability("ignoreModifications");
        this.ignoreModifications = ignoreModifications;
    }

    public boolean isIgnoreModifications() {
        return this.ignoreModifications;
    }

    @ConfigurationAttribute(name="purgeOnStartup", containingElement="loader", description="If true, purge node state on startup")
    public void setPurgeOnStartup(boolean purgeOnStartup) {
        this.testImmutability("purgeOnStartup");
        this.purgeOnStartup = purgeOnStartup;
    }

    public SingletonStoreConfig getSingletonStoreConfig() {
        return this.singletonStore;
    }

    public void setSingletonStoreConfig(SingletonStoreConfig singletonStoreConfig) {
        this.testImmutability("singletonStore");
        this.singletonStore = singletonStoreConfig;
    }

    public AsyncStoreConfig getAsyncStoreConfig() {
        return this.async;
    }

    public void setAsyncStoreConfig(AsyncStoreConfig asyncStoreConfig) {
        this.testImmutability("async");
        this.async = asyncStoreConfig;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof AbstractCacheStoreConfig)) {
                return false;
            }
            AbstractCacheStoreConfig i = (AbstractCacheStoreConfig)obj;
            return this.equalsExcludingProperties(i);
        }
        return false;
    }

    protected boolean equalsExcludingProperties(Object obj) {
        AbstractCacheStoreConfig other = (AbstractCacheStoreConfig)obj;
        return Util.safeEquals(this.cacheLoaderClassName, other.cacheLoaderClassName) && this.ignoreModifications == other.ignoreModifications && this.fetchPersistentState == other.fetchPersistentState && Util.safeEquals(this.singletonStore, other.singletonStore) && Util.safeEquals(this.async, other.async) && Util.safeEquals(this.purgeSynchronously, other.purgeSynchronously);
    }

    public int hashCode() {
        return 31 * this.hashCodeExcludingProperties() + (this.properties == null ? 0 : this.properties.hashCode());
    }

    protected int hashCodeExcludingProperties() {
        int result = 17;
        result = 31 * result + (this.cacheLoaderClassName == null ? 0 : this.cacheLoaderClassName.hashCode());
        result = 31 * result + (this.ignoreModifications != false ? 0 : 1);
        result = 31 * result + (this.fetchPersistentState != false ? 0 : 1);
        result = 31 * result + (this.singletonStore == null ? 0 : this.singletonStore.hashCode());
        result = 31 * result + (this.async == null ? 0 : this.async.hashCode());
        result = 31 * result + (this.purgeOnStartup != false ? 0 : 1);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "className='" + this.cacheLoaderClassName + '\'' + ", ignoreModifications=" + this.ignoreModifications + ", fetchPersistentState=" + this.fetchPersistentState + ", properties=" + this.properties + ", purgeOnStartup=" + this.purgeOnStartup + "}," + ", singletonStore{" + this.singletonStore + '}' + ", async{" + this.async + '}' + ", purgeSynchronously{" + this.purgeSynchronously + '}';
    }

    public AbstractCacheStoreConfig clone() {
        AbstractCacheStoreConfig clone = (AbstractCacheStoreConfig)super.clone();
        if (this.singletonStore != null) {
            clone.setSingletonStoreConfig(this.singletonStore.clone());
        }
        if (this.async != null) {
            clone.setAsyncStoreConfig(this.async.clone());
        }
        return clone;
    }
}

