/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bucket;

import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.bucket.Bucket;

public abstract class BucketBasedCacheStore
extends LockSupportCacheStore {
    protected InternalCacheEntry loadLockSafe(Object key, String lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket == null) {
            return null;
        }
        InternalCacheEntry se = bucket.getEntry(key);
        if (se != null && se.isExpired()) {
            return null;
        }
        return se;
    }

    protected void storeLockSafe(InternalCacheEntry ed, String lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket != null) {
            bucket.addEntry(ed);
            this.saveBucket(bucket);
        } else {
            bucket = new Bucket();
            bucket.setBucketName(lockingKey);
            bucket.addEntry(ed);
            this.insertBucket(bucket);
        }
    }

    protected boolean removeLockSafe(Object key, String lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket == null) {
            return false;
        }
        boolean success = bucket.removeEntry(key);
        if (success) {
            this.saveBucket(bucket);
        }
        return success;
    }

    protected String getLockFromKey(Object key) {
        return String.valueOf(key.hashCode());
    }

    protected abstract void insertBucket(Bucket var1) throws CacheLoaderException;

    protected abstract void saveBucket(Bucket var1) throws CacheLoaderException;

    protected abstract Bucket loadBucket(String var1) throws CacheLoaderException;
}

