/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.ConfigurationAttribute;
import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.Dynamic;

@ConfigurationElement(name="async", parent="loader")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AsyncStoreConfig
extends AbstractNamedCacheConfigurationBean {
    @XmlAttribute
    Boolean enabled = false;
    @XmlAttribute
    Integer threadPoolSize = 1;
    @Dynamic
    @XmlAttribute
    Long mapLockTimeout = 5000L;

    public boolean isEnabled() {
        return this.enabled;
    }

    @ConfigurationAttribute(name="enabled", containingElement="async", description="If true, modifications are stored in the cache store asynchronously.")
    public void setEnabled(boolean enabled) {
        this.testImmutability("enabled");
        this.enabled = enabled;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @ConfigurationAttribute(name="threadPoolSize", containingElement="async", description="Size of the thread pool whose threads are responsible for applying the modifications.")
    public void setThreadPoolSize(int threadPoolSize) {
        this.testImmutability("threadPoolSize");
        this.threadPoolSize = threadPoolSize;
    }

    public long getMapLockTimeout() {
        return this.mapLockTimeout;
    }

    @ConfigurationAttribute(name="mapLockTimeout", containingElement="async", description="Lock timeout for access to map containing latest state.")
    public void setMapLockTimeout(long stateLockTimeout) {
        this.testImmutability("mapLockTimeout");
        this.mapLockTimeout = stateLockTimeout;
    }

    public AsyncStoreConfig clone() {
        try {
            return (AsyncStoreConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should not happen!", e);
        }
    }
}

