/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.commands.RemoteCommandFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@NonVolatile
public class VersionAwareMarshaller
extends AbstractMarshaller {
    private static final Log log = LogFactory.getLog(VersionAwareMarshaller.class);
    private boolean trace = log.isTraceEnabled();
    private static final int VERSION_400 = 400;
    private static final int CUSTOM_MARSHALLER = 999;
    private final JBossMarshaller defaultMarshaller = new JBossMarshaller();
    private ClassLoader loader;
    private RemoteCommandFactory remoteCommandFactory;

    @Inject
    public void inject(ClassLoader loader, RemoteCommandFactory remoteCommandFactory) {
        this.loader = loader;
        this.remoteCommandFactory = remoteCommandFactory;
    }

    @Start(priority=9)
    public void start() {
        this.defaultMarshaller.start(this.loader, this.remoteCommandFactory, this);
    }

    @Stop
    public void stop() {
        this.defaultMarshaller.stop();
    }

    protected int getCustomMarshallerVersionInt() {
        return 999;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer objectToBuffer(Object obj) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
        ObjectOutput out = this.startObjectOutput(baos, false);
        try {
            this.defaultMarshaller.objectToObjectStream(obj, out);
        }
        finally {
            this.finishObjectOutput(out);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes, offset, len);
        ObjectInput in = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.defaultMarshaller.objectFromObjectStream(in);
        }
        finally {
            this.finishObjectInput(in);
        }
        return o;
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        ObjectOutput out = this.defaultMarshaller.startObjectOutput(os, isReentrant);
        try {
            out.writeShort(400);
            if (this.trace) {
                log.trace((Object)"Wrote version {0}", 400);
            }
        }
        catch (Exception e) {
            this.finishObjectOutput(out);
            log.error("Unable to read version id from first two bytes of stream, barfing.");
            throw new IOException("Unable to read version id from first two bytes of stream : " + e.getMessage());
        }
        return out;
    }

    public void finishObjectOutput(ObjectOutput oo) {
        this.defaultMarshaller.finishObjectOutput(oo);
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        this.defaultMarshaller.objectToObjectStream(obj, out);
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        ObjectInput in = this.defaultMarshaller.startObjectInput(is, isReentrant);
        try {
            short versionId = in.readShort();
            if (this.trace) {
                log.trace((Object)"Read version {0}", versionId);
            }
        }
        catch (Exception e) {
            this.finishObjectInput(in);
            log.error("Unable to read version id from first two bytes of stream, barfing.");
            throw new IOException("Unable to read version id from first two bytes of stream: " + e.getMessage());
        }
        return in;
    }

    public void finishObjectInput(ObjectInput oi) {
        this.defaultMarshaller.finishObjectInput(oi);
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        return this.defaultMarshaller.objectFromObjectStream(in);
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException {
        ByteBuffer b = this.objectToBuffer(obj);
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }
}

