/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.CacheException;
import org.infinispan.commands.RemoteCommandFactory;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.ConstantObjectTable;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

public class JBossMarshaller
extends AbstractMarshaller {
    private static final Log log = LogFactory.getLog(JBossMarshaller.class);
    private static final String DEFAULT_MARSHALLER_FACTORY = "org.jboss.marshalling.river.RiverMarshallerFactory";
    private ClassLoader defaultCl;
    private MarshallingConfiguration configuration;
    private MarshallerFactory factory;
    private ConstantObjectTable objectTable;
    private ThreadLocal<org.jboss.marshalling.Marshaller> marshallerTL = new ThreadLocal<org.jboss.marshalling.Marshaller>(){

        @Override
        protected org.jboss.marshalling.Marshaller initialValue() {
            try {
                return JBossMarshaller.this.factory.createMarshaller(JBossMarshaller.this.configuration);
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
        }
    };
    private ThreadLocal<Unmarshaller> unmarshallerTL = new ThreadLocal<Unmarshaller>(){

        @Override
        protected Unmarshaller initialValue() {
            try {
                return JBossMarshaller.this.factory.createUnmarshaller(JBossMarshaller.this.configuration);
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
        }
    };

    public void start(ClassLoader defaultCl, RemoteCommandFactory cmdFactory, Marshaller ispnMarshaller) {
        log.debug("Using JBoss Marshalling based marshaller.");
        this.defaultCl = defaultCl;
        try {
            this.factory = (MarshallerFactory)Util.getInstance(DEFAULT_MARSHALLER_FACTORY);
        }
        catch (Exception e) {
            throw new CacheException("Unable to load JBoss Marshalling marshaller factory org.jboss.marshalling.river.RiverMarshallerFactory", e);
        }
        this.objectTable = this.createCustomObjectTable(cmdFactory, ispnMarshaller);
        this.configuration = new MarshallingConfiguration();
        this.configuration.setCreator((Creator)new SunReflectiveCreator());
        this.configuration.setObjectTable((ObjectTable)this.objectTable);
        this.configuration.setClassResolver((ClassResolver)new ContextClassResolver());
    }

    public void stop() {
        this.defaultCl = null;
        if (this.objectTable != null) {
            this.objectTable.stop();
        }
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException {
        ByteBuffer b = this.objectToBuffer(obj);
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer objectToBuffer(Object o) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
        ObjectOutput marshaller = this.startObjectOutput(baos, false);
        try {
            this.objectToObjectStream(o, marshaller);
        }
        finally {
            this.finishObjectOutput(marshaller);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        org.jboss.marshalling.Marshaller marshaller = isReentrant ? this.factory.createMarshaller(this.configuration) : this.marshallerTL.get();
        marshaller.start(Marshalling.createByteOutput((OutputStream)os));
        return marshaller;
    }

    public void finishObjectOutput(ObjectOutput oo) {
        try {
            ((org.jboss.marshalling.Marshaller)oo).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        ClassLoader toUse = this.defaultCl;
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        if (old != null) {
            toUse = old;
        }
        try {
            current.setContextClassLoader(toUse);
            out.writeObject(obj);
        }
        finally {
            current.setContextClassLoader(old);
        }
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, offset, length);
        ObjectInput unmarshaller = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.objectFromObjectStream(unmarshaller);
        }
        finally {
            this.finishObjectInput(unmarshaller);
        }
        return o;
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        Unmarshaller unmarshaller = isReentrant ? this.factory.createUnmarshaller(this.configuration) : this.unmarshallerTL.get();
        unmarshaller.start(Marshalling.createByteInput((InputStream)is));
        return unmarshaller;
    }

    public void finishObjectInput(ObjectInput oi) {
        try {
            ((Unmarshaller)oi).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }

    private ConstantObjectTable createCustomObjectTable(RemoteCommandFactory cmdFactory, Marshaller ispnMarshaller) {
        ConstantObjectTable objectTable = new ConstantObjectTable();
        objectTable.start(cmdFactory, ispnMarshaller);
        return objectTable;
    }
}

