/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;

@Marshallable(externalizer=Externalizer.class, id=6)
public class ExtendedResponse
extends ValidResponse {
    private final boolean replayIgnoredRequests;
    private final Response response;

    public ExtendedResponse(Response response, boolean replayIgnoredRequests) {
        this.response = response;
        this.replayIgnoredRequests = replayIgnoredRequests;
    }

    public boolean isReplayIgnoredRequests() {
        return this.replayIgnoredRequests;
    }

    public Response getResponse() {
        return this.response;
    }

    public boolean isSuccessful() {
        return this.response.isSuccessful();
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            ExtendedResponse er = (ExtendedResponse)subject;
            output.writeBoolean(er.replayIgnoredRequests);
            output.writeObject(er.response);
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean replayIgnoredRequests = input.readBoolean();
            Response response = (Response)input.readObject();
            return new ExtendedResponse(response, replayIgnoredRequests);
        }
    }
}

