/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Marshallable(externalizer=Externalizer.class, id=43)
public class DeadlockDetectingGlobalTransaction
extends GlobalTransaction {
    private static Log log = LogFactory.getLog(DeadlockDetectingGlobalTransaction.class);
    public static final boolean trace = log.isTraceEnabled();
    private Set<Address> replicatingTo = Collections.EMPTY_SET;
    private volatile transient Thread processingThread;
    private volatile long coinToss;
    private volatile boolean isMarkedForRollback;
    private volatile transient Object lockInterntion;

    public DeadlockDetectingGlobalTransaction() {
    }

    DeadlockDetectingGlobalTransaction(Address addr, boolean remote) {
        super(addr, remote);
    }

    DeadlockDetectingGlobalTransaction(boolean remote) {
        super(null, remote);
    }

    public boolean isReplicatingTo(Address address) {
        if (this.replicatingTo == null) {
            return true;
        }
        return this.replicatingTo.contains(address);
    }

    public void setProcessingThread(Thread replicationThread) {
        if (trace) {
            log.trace("Setting thread " + Thread.currentThread() + "on tx [" + this + "]");
        }
        this.processingThread = replicationThread;
    }

    public synchronized void interruptProcessingThread() {
        if (this.isMarkedForRollback) {
            if (trace) {
                log.trace("Not interrupting as tx is marked for rollback");
            }
            return;
        }
        if (this.processingThread == null) {
            if (trace) {
                log.trace("Processing thread is null, nothing to interrupt");
            }
            return;
        }
        if (trace) {
            StackTraceElement[] stackTraceElements = this.processingThread.getStackTrace();
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                builder.append("            ").append(stackTraceElement).append('\n');
            }
            log.trace("About to interrupt thread: " + this.processingThread + ". Thread's stack trace is: \n" + builder.toString());
        }
        this.processingThread.interrupt();
    }

    public void setReplicatingTo(Set<Address> targets) {
        this.replicatingTo = targets;
    }

    public boolean thisWillInterrupt(DeadlockDetectingGlobalTransaction globalTransaction) {
        return this.coinToss > globalTransaction.coinToss;
    }

    public void setCoinToss(long coinToss) {
        this.coinToss = coinToss;
    }

    public long getCoinToss() {
        return this.coinToss;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeadlockDetectingGlobalTransaction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeadlockDetectingGlobalTransaction that = (DeadlockDetectingGlobalTransaction)o;
        if (this.coinToss != that.coinToss) {
            return false;
        }
        return !(this.replicatingTo != null ? !((Object)this.replicatingTo).equals(that.replicatingTo) : that.replicatingTo != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.replicatingTo != null ? ((Object)this.replicatingTo).hashCode() : 0);
        result = 31 * result + (int)(this.coinToss ^ this.coinToss >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "DeadlockDetectingGlobalTransaction{replicatingTo=" + this.replicatingTo + ", replicationThread=" + this.processingThread + ", coinToss=" + this.coinToss + "} " + super.toString();
    }

    public synchronized boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    public synchronized void setMarkedForRollback(boolean markedForRollback) {
        this.isMarkedForRollback = markedForRollback;
    }

    public Object getLockInterntion() {
        return this.lockInterntion;
    }

    public void setLockInterntion(Object lockInterntion) {
        this.lockInterntion = lockInterntion;
    }

    public static class Externalizer
    extends GlobalTransaction.Externalizer {
        public Externalizer() {
            this.gtxFactory = new GlobalTransactionFactory(true);
        }

        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            super.writeObject(output, subject);
            DeadlockDetectingGlobalTransaction ddGt = (DeadlockDetectingGlobalTransaction)subject;
            output.writeLong(ddGt.getCoinToss());
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            DeadlockDetectingGlobalTransaction ddGt = (DeadlockDetectingGlobalTransaction)super.readObject(input);
            ddGt.setCoinToss(input.readLong());
            return ddGt;
        }
    }
}

