/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransactionFactory;

@Marshallable(externalizer=Externalizer.class, id=38)
public class GlobalTransaction
implements Cloneable {
    private static final long serialVersionUID = 8011434781266976149L;
    private static AtomicLong sid = new AtomicLong(0L);
    private long id = -1L;
    protected transient Address addr = null;
    private transient int hash_code = -1;
    private transient boolean remote = false;

    GlobalTransaction() {
    }

    GlobalTransaction(Address addr, boolean remote) {
        this.id = sid.incrementAndGet();
        this.addr = addr;
        this.remote = remote;
    }

    public Address getAddress() {
        return this.addr;
    }

    public long getId() {
        return this.id;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id;
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        GlobalTransaction otherGtx = (GlobalTransaction)other;
        boolean aeq = this.addr == null ? otherGtx.addr == null : this.addr.equals(otherGtx.addr);
        return aeq && this.id == otherGtx.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalTransaction:<").append(this.addr).append(">:").append(this.id);
        return sb.toString();
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAddress(Address address) {
        this.addr = address;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        protected GlobalTransactionFactory gtxFactory = new GlobalTransactionFactory();

        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            GlobalTransaction gtx = (GlobalTransaction)subject;
            output.writeLong(gtx.id);
            output.writeObject(gtx.addr);
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            GlobalTransaction gtx = this.gtxFactory.instantiateGlobalTransaction();
            gtx.id = input.readLong();
            gtx.addr = (Address)input.readObject();
            return gtx;
        }
    }
}

