/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransactionFactory;
import org.infinispan.transaction.xa.RemoteTransaction;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionTable {
    private static Log log = LogFactory.getLog(TransactionTable.class);
    private static boolean trace = log.isTraceEnabled();
    private Map<Transaction, TransactionXaAdapter> localTransactions = new HashMap<Transaction, TransactionXaAdapter>();
    private Map<GlobalTransaction, RemoteTransaction> remoteTransactions = new HashMap<GlobalTransaction, RemoteTransaction>();
    private CommandsFactory commandsFactory;
    private Configuration configuration;
    private InvocationContextContainer icc;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private RpcManager rpcManager;
    private GlobalTransactionFactory gtf;

    @Inject
    public void initialize(CommandsFactory commandsFactory, RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, GlobalTransactionFactory gtf) {
        this.commandsFactory = commandsFactory;
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.gtf = gtf;
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return this.remoteTransactions.get(txId);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        RemoteTransaction remoteTransaction = new RemoteTransaction(modifications, globalTx);
        RemoteTransaction transaction = this.remoteTransactions.put(globalTx, remoteTransaction);
        if (transaction != null) {
            String message = "A remote transaction with the given id was already registred!!!";
            log.error(message);
            throw new IllegalStateException(message);
        }
        if (trace) {
            log.trace("Created and registered remote transaction " + remoteTransaction);
        }
        return remoteTransaction;
    }

    public TransactionXaAdapter getOrCreateXaAdapter(Transaction transaction, InvocationContext ctx) {
        TransactionXaAdapter current = this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.gtf.newGlobalTransaction(localAddress, false);
            current = new TransactionXaAdapter(tx, this.icc, this.invoker, this.commandsFactory, this.configuration, this, transaction);
            this.localTransactions.put(transaction, current);
            try {
                transaction.enlistResource((XAResource)current);
            }
            catch (Exception e) {
                log.error("Failed to emlist TransactionXaAdapter to transaction");
                throw new CacheException(e);
            }
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(Transaction tx) {
        return this.localTransactions.remove(tx) != null;
    }

    public boolean removeRemoteTransaction(GlobalTransaction txId) {
        boolean existed;
        boolean bl = existed = this.remoteTransactions.remove(txId) != null;
        if (trace) {
            log.trace("Removed " + txId + " from transaction table. Returning " + existed);
        }
        return existed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public TransactionXaAdapter getXaCacheAdapter(Transaction tx) {
        return this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }
}

