/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionTable;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionXaAdapter
implements CacheTransaction,
XAResource {
    private static Log log = LogFactory.getLog(TransactionXaAdapter.class);
    private static boolean trace = log.isTraceEnabled();
    private int txTimeout;
    private List<WriteCommand> modifications;
    private BidirectionalMap<Object, CacheEntry> lookedUpEntries;
    private GlobalTransaction globalTx;
    private InvocationContextContainer icc;
    private InterceptorChain invoker;
    private CommandsFactory commandsFactory;
    private Configuration configuration;
    private TransactionTable txTable;
    private Transaction transaction;

    public TransactionXaAdapter(GlobalTransaction globalTx, InvocationContextContainer icc, InterceptorChain invoker, CommandsFactory commandsFactory, Configuration configuration, TransactionTable txTable, Transaction transaction) {
        this.globalTx = globalTx;
        this.icc = icc;
        this.invoker = invoker;
        this.commandsFactory = commandsFactory;
        this.configuration = configuration;
        this.txTable = txTable;
        this.transaction = transaction;
    }

    public void addModification(WriteCommand mod) {
        if (this.modifications == null) {
            this.modifications = new ArrayList<WriteCommand>(8);
        }
        this.modifications.add(mod);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.configuration.isOnePhaseCommit()) {
            if (trace) {
                log.trace("Recieved prepare for tx: " + xid + " . Skipping call as 1PC will be used.");
            }
            return 0;
        }
        PrepareCommand prepareCommand = this.commandsFactory.buildPrepareCommand(this.globalTx, this.modifications, this.configuration.isOnePhaseCommit());
        if (trace) {
            log.trace("Sending prepare command through the chain: " + prepareCommand);
        }
        LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
        ctx.setXaCache(this);
        try {
            this.invoker.invoke(ctx, prepareCommand);
            return 0;
        }
        catch (Throwable e) {
            log.error((Object)"Error while processing PrepareCommand", e);
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean isOnePhase) throws XAException {
        block11: {
            if (isOnePhase) {
                this.prepare(xid);
            }
            if (trace) {
                log.trace("commiting TransactionXaAdapter: " + this.globalTx);
            }
            try {
                LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
                ctx.setXaCache(this);
                if (this.configuration.isOnePhaseCommit()) {
                    if (trace) {
                        log.trace("Doing an 1PC prepare call on the interceptor chain");
                    }
                    PrepareCommand command = this.commandsFactory.buildPrepareCommand(this.globalTx, this.modifications, true);
                    try {
                        this.invoker.invoke(ctx, command);
                        break block11;
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error while processing 1PC PrepareCommand", e);
                        throw new XAException(-3);
                    }
                }
                CommitCommand commitCommand = this.commandsFactory.buildCommitCommand(this.globalTx);
                try {
                    this.invoker.invoke(ctx, commitCommand);
                }
                catch (Throwable e) {
                    log.error((Object)"Error while processing 1PC PrepareCommand", e);
                    throw new XAException(-3);
                }
            }
            finally {
                this.txTable.removeLocalTransaction(this.transaction);
                this.modifications = null;
            }
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(this.globalTx);
        LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
        ctx.setXaCache(this);
        try {
            this.invoker.invoke(ctx, rollbackCommand);
        }
        catch (Throwable e) {
            log.error((Object)"Exception while rollback", e);
            throw new XAException(8);
        }
        finally {
            this.txTable.removeLocalTransaction(this.transaction);
            this.modifications = null;
        }
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        if (trace) {
            log.trace("start called on tx " + this.globalTx);
        }
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        if (trace) {
            log.trace("end called on tx " + this.globalTx);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (trace) {
            log.trace("forget called");
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (trace) {
            log.trace("start called");
        }
        return this.txTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (!(xaResource instanceof TransactionXaAdapter)) {
            return false;
        }
        TransactionXaAdapter other = (TransactionXaAdapter)xaResource;
        return other.equals(this);
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        if (trace) {
            log.trace("recover called: " + i);
        }
        return null;
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        this.txTimeout = i;
        return true;
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        this.initLookedUpEntries();
        this.lookedUpEntries.putAll(entries);
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.lookedUpEntries == null) {
            return null;
        }
        return (CacheEntry)this.lookedUpEntries.get(key);
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? InfinispanCollections.emptyBidirectionalMap() : this.lookedUpEntries;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.initLookedUpEntries();
        this.lookedUpEntries.put(key, e);
    }

    private void initLookedUpEntries() {
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new BidirectionalLinkedHashMap<Object, CacheEntry>(4);
        }
    }

    public GlobalTransaction getGlobalTx() {
        return this.globalTx;
    }

    @Override
    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.globalTx;
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionXaAdapter)) {
            return false;
        }
        TransactionXaAdapter that = (TransactionXaAdapter)o;
        return this.globalTx.equals(that.globalTx);
    }

    public int hashCode() {
        return this.globalTx.hashCode();
    }

    public String toString() {
        return "TransactionXaAdapter{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", globalTx=" + this.globalTx + ", transaction=" + this.transaction + ", txTimeout=" + this.txTimeout + '}';
    }
}

