/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class OwnableReentrantLock
extends AbstractQueuedSynchronizer
implements Lock {
    private static Log log = LogFactory.getLog(OwnableReentrantLock.class);
    transient Object owner;
    transient InvocationContextContainer icc;

    public OwnableReentrantLock(InvocationContextContainer icc) {
        if (icc == null) {
            throw new IllegalArgumentException("Invocation context container cannot be null!");
        }
        this.icc = icc;
    }

    protected final Object currentRequestor() {
        InvocationContext invocationContext = this.icc.getInvocationContext();
        Object o = invocationContext.getLockOwner();
        return o;
    }

    public void lock() {
        if (this.compareAndSetState(0, 1)) {
            this.owner = this.currentRequestor();
        } else {
            this.acquire(1);
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    public boolean tryLock() {
        return this.tryAcquire(1);
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireNanos(1, unit.toNanos(time));
    }

    public void unlock() {
        try {
            this.release(1);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public AbstractQueuedSynchronizer.ConditionObject newCondition() {
        throw new UnsupportedOperationException("Not supported in this implementation!");
    }

    protected final boolean tryAcquire(int acquires) {
        Object current = this.currentRequestor();
        int c = this.getState();
        if (c == 0) {
            if (this.compareAndSetState(0, acquires)) {
                this.owner = current;
                return true;
            }
        } else if (current.equals(this.owner)) {
            this.setState(c + acquires);
            return true;
        }
        return false;
    }

    protected final boolean tryRelease(int releases) {
        int c = this.getState() - releases;
        if (!this.currentRequestor().equals(this.owner)) {
            return false;
        }
        boolean free = false;
        if (c == 0) {
            free = true;
            this.owner = null;
        }
        this.setState(c);
        return free;
    }

    protected final boolean isHeldExclusively() {
        return this.getState() != 0 && this.currentRequestor().equals(this.owner);
    }

    public final Object getOwner() {
        int c = this.getState();
        Object o = this.owner;
        return c == 0 ? null : o;
    }

    public final int getHoldCount() {
        int c = this.getState();
        Object o = this.owner;
        return this.currentRequestor().equals(o) ? c : 0;
    }

    public final boolean isLocked() {
        return this.getState() != 0;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setState(0);
    }

    public String toString() {
        Object owner = this.getOwner();
        return super.toString() + (owner == null ? "[Unlocked]" : "[Locked by " + owner + "]");
    }
}

