/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=ReplicableCommandExternalizer.class, id=50)
public class RehashControlCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 17;
    Type type;
    Address sender;
    Map<Object, InternalCacheValue> state;
    ConsistentHash oldCH;
    List<Address> nodesLeft;
    ConsistentHash newCH;
    DistributionManager distributionManager;
    Transport transport;
    Configuration configuration;
    DataContainer dataContainer;
    List<WriteCommand> txLogCommands;
    List<PrepareCommand> pendingPrepares;
    CommandsFactory commandsFactory;
    private static final Log log = LogFactory.getLog(RehashControlCommand.class);

    public RehashControlCommand() {
    }

    public RehashControlCommand(String cacheName, Type type, Address sender, Map<Object, InternalCacheValue> state, ConsistentHash oldConsistentHash, ConsistentHash consistentHash, List<Address> leavers, CommandsFactory commandsFactory) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.state = state;
        this.oldCH = oldConsistentHash;
        this.newCH = consistentHash;
        this.nodesLeft = leavers;
        this.commandsFactory = commandsFactory;
    }

    public RehashControlCommand(String cacheName, Type type, Address sender, List<WriteCommand> txLogCommands, List<PrepareCommand> pendingPrepares, CommandsFactory commandsFactory) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.txLogCommands = txLogCommands;
        this.pendingPrepares = pendingPrepares;
        this.commandsFactory = commandsFactory;
    }

    public RehashControlCommand(Transport transport) {
        this.transport = transport;
    }

    public void init(DistributionManager distributionManager, Configuration configuration, DataContainer dataContainer, CommandsFactory commandsFactory) {
        this.distributionManager = distributionManager;
        this.configuration = configuration;
        this.dataContainer = dataContainer;
        this.commandsFactory = commandsFactory;
        for (List commandList : Arrays.asList(this.txLogCommands, this.pendingPrepares)) {
            if (commandList == null) continue;
            for (ReplicableCommand cmd : commandList) {
                commandsFactory.initializeReplicableCommand(cmd);
            }
        }
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.type) {
            case JOIN_REQ: {
                return this.distributionManager.requestPermissionToJoin(this.sender);
            }
            case JOIN_REHASH_START: {
                this.distributionManager.informRehashOnJoin(this.sender, true);
                return null;
            }
            case JOIN_REHASH_END: {
                this.distributionManager.informRehashOnJoin(this.sender, false);
                return null;
            }
            case JOIN_COMPLETE: {
                this.distributionManager.notifyJoinComplete(this.sender);
                return null;
            }
            case PULL_STATE_JOIN: {
                return this.pullStateForJoin();
            }
            case PULL_STATE_LEAVE: {
                return this.pullStateForLeave();
            }
            case PUSH_STATE: {
                return this.pushState();
            }
            case DRAIN_TX: {
                this.distributionManager.applyRemoteTxLog(this.txLogCommands);
                return null;
            }
            case DRAIN_TX_PREPARES: {
                for (PrepareCommand pc : this.pendingPrepares) {
                    pc.perform(null);
                }
                return null;
            }
        }
        throw new CacheException("Unknown rehash control command type " + (Object)((Object)this.type));
    }

    public Map<Object, InternalCacheValue> pullStateForJoin() throws CacheLoaderException {
        HashMap<Object, InternalCacheValue> state = new HashMap<Object, InternalCacheValue>();
        for (InternalCacheEntry ice : this.dataContainer) {
            Object k = ice.getKey();
            if (!this.shouldTransferOwnershipToJoinNode(k)) continue;
            state.put(k, ice.toInternalCacheValue());
        }
        CacheStore cacheStore = this.distributionManager.getCacheStoreForRehashing();
        if (cacheStore != null) {
            for (Object k : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                InternalCacheValue v;
                if (state.containsKey(k) || !this.shouldTransferOwnershipToJoinNode(k) || (v = this.loadValue(cacheStore, k)) == null) continue;
                state.put(k, v);
            }
        }
        return state;
    }

    public Map<Object, InternalCacheValue> pullStateForLeave() throws CacheLoaderException {
        HashMap<Object, InternalCacheValue> state = new HashMap<Object, InternalCacheValue>();
        for (InternalCacheEntry ice : this.dataContainer) {
            Object k = ice.getKey();
            if (!this.shouldTransferOwnershipFromLeftNodes(k)) continue;
            state.put(k, ice.toInternalCacheValue());
        }
        CacheStore cacheStore = this.distributionManager.getCacheStoreForRehashing();
        if (cacheStore != null) {
            for (Object k : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                InternalCacheValue v;
                if (state.containsKey(k) || !this.shouldTransferOwnershipFromLeftNodes(k) || (v = this.loadValue(cacheStore, k)) == null) continue;
                state.put(k, v);
            }
        }
        return state;
    }

    private boolean shouldTransferOwnershipFromLeftNodes(Object k) {
        Address self = this.transport.getAddress();
        int numCopies = this.configuration.getNumOwners();
        List<Address> oldList = this.oldCH.locate(k, numCopies);
        boolean localToThisNode = oldList.indexOf(self) >= 0;
        boolean senderIsNewOwner = this.newCH.isKeyLocalToAddress(this.sender, k, numCopies);
        for (Address leftNodeAddress : this.nodesLeft) {
            boolean localToLeftNode = oldList.indexOf(leftNodeAddress) >= 0;
            if (!localToLeftNode || !senderIsNewOwner || !localToThisNode) continue;
            return true;
        }
        return false;
    }

    private InternalCacheValue loadValue(CacheStore cs, Object k) {
        try {
            InternalCacheEntry ice = cs.load(k);
            return ice == null ? null : ice.toInternalCacheValue();
        }
        catch (CacheLoaderException cle) {
            log.warn((Object)("Unable to load " + k + " from cache loader"), cle);
            return null;
        }
    }

    final boolean shouldTransferOwnershipToJoinNode(Object k) {
        List<Address> newOwnerList;
        Address self = this.transport.getAddress();
        int numCopies = this.configuration.getNumOwners();
        List<Address> oldOwnerList = this.oldCH.locate(k, numCopies);
        return !oldOwnerList.isEmpty() && self.equals(oldOwnerList.get(0)) && (newOwnerList = this.newCH.locate(k, numCopies)).contains(this.sender);
    }

    public Object pushState() {
        this.distributionManager.applyReceivedState(this.state);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheName, (byte)this.type.ordinal(), this.sender, this.state, this.oldCH, this.nodesLeft, this.newCH, this.txLogCommands, this.pendingPrepares};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.cacheName = (String)parameters[i++];
        this.type = Type.values()[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.state = (Map)parameters[i++];
        this.oldCH = (ConsistentHash)parameters[i++];
        this.nodesLeft = (List)parameters[i++];
        this.newCH = (ConsistentHash)parameters[i++];
        this.txLogCommands = (List)parameters[i++];
        this.pendingPrepares = (List)parameters[i++];
    }

    public String toString() {
        return "RehashControlCommand{type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", state=" + this.state + ", oldConsistentHash=" + this.oldCH + ", nodesLeft=" + this.nodesLeft + ", consistentHash=" + this.newCH + ", txLogCommands=" + this.txLogCommands + ", pendingPrepares=" + this.pendingPrepares + '}';
    }

    public static enum Type {
        JOIN_REQ,
        JOIN_REHASH_START,
        JOIN_REHASH_END,
        JOIN_COMPLETE,
        JOIN_ABORT,
        PULL_STATE_JOIN,
        PULL_STATE_LEAVE,
        PUSH_STATE,
        DRAIN_TX,
        DRAIN_TX_PREPARES;

    }
}

