/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.util.Util;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class CacheLoaderManagerConfig
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 2210349340378984424L;
    protected Boolean passivation = false;
    protected Boolean preload = false;
    protected Boolean shared = false;
    protected List<CacheLoaderConfig> cacheLoaderConfigs = new LinkedList<CacheLoaderConfig>();

    public Boolean isPreload() {
        return this.preload;
    }

    @XmlAttribute
    public void setPreload(Boolean preload) {
        this.testImmutability("preload");
        this.preload = preload;
    }

    @XmlAttribute
    public void setPassivation(Boolean passivation) {
        this.testImmutability("passivation");
        this.passivation = passivation;
    }

    public Boolean isPassivation() {
        return this.passivation;
    }

    @XmlAttribute
    public void setShared(Boolean shared) {
        this.testImmutability("shared");
        this.shared = shared;
    }

    public Boolean isShared() {
        return this.shared;
    }

    public void addCacheLoaderConfig(CacheLoaderConfig clc) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs.add(clc);
    }

    @XmlElement(name="loader")
    public List<CacheLoaderConfig> getCacheLoaderConfigs() {
        this.testImmutability("cacheLoaderConfigs");
        return this.cacheLoaderConfigs;
    }

    public void setCacheLoaderConfigs(List<CacheLoaderConfig> configs) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs = configs == null ? new LinkedList() : configs;
    }

    public CacheLoaderConfig getFirstCacheLoaderConfig() {
        if (this.cacheLoaderConfigs.isEmpty()) {
            return null;
        }
        return this.cacheLoaderConfigs.get(0);
    }

    public Boolean isFetchPersistentState() {
        for (CacheLoaderConfig iclc : this.cacheLoaderConfigs) {
            if (!(iclc instanceof CacheStoreConfig) || !((CacheStoreConfig)iclc).isFetchPersistentState().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean useChainingCacheLoader() {
        return this.isPassivation() == false && this.cacheLoaderConfigs.size() > 1;
    }

    public String toString() {
        return "CacheLoaderManagerConfig{" + "shared=" + this.shared + ", passivation=" + this.passivation + ", preload='" + this.preload + '\'' + ", cacheLoaderConfigs.size()=" + this.cacheLoaderConfigs.size() + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CacheLoaderManagerConfig) {
            CacheLoaderManagerConfig other = (CacheLoaderManagerConfig)obj;
            return this.passivation.equals(other.passivation) && this.shared.equals(other.shared) && Util.safeEquals(this.preload, other.preload) && Util.safeEquals(this.cacheLoaderConfigs, other.cacheLoaderConfigs);
        }
        return false;
    }

    public void accept(ConfigurationBeanVisitor v) {
        for (CacheLoaderConfig clc : this.cacheLoaderConfigs) {
            clc.accept(v);
        }
        v.visitCacheLoaderManagerConfig(this);
    }

    public int hashCode() {
        int result = 19;
        result = 51 * result + (this.passivation != false ? 0 : 1);
        result = 51 * result + (this.shared != false ? 0 : 1);
        result = 51 * result + (this.preload != false ? 0 : 1);
        result = 51 * result + (this.cacheLoaderConfigs == null ? 0 : ((Object)this.cacheLoaderConfigs).hashCode());
        return result;
    }

    @Override
    public CacheLoaderManagerConfig clone() throws CloneNotSupportedException {
        CacheLoaderManagerConfig clone = (CacheLoaderManagerConfig)super.clone();
        if (this.cacheLoaderConfigs != null) {
            LinkedList<CacheLoaderConfig> clcs = new LinkedList<CacheLoaderConfig>();
            for (CacheLoaderConfig clc : this.cacheLoaderConfigs) {
                clcs.add(clc.clone());
            }
            clone.cacheLoaderConfigs = clcs;
        }
        return clone;
    }
}

