/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.concurrent.locks.LockManager;

public class InvocationContextInterceptor
extends CommandInterceptor {
    LockManager lockManager;

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command);
    }

    @Inject
    public void injectLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    private Object handleAll(InvocationContext ctx, VisitableCommand command) throws Throwable {
        boolean suppressExceptions = false;
        if (this.trace) {
            this.log.trace("Invoked with command " + command + " and InvocationContext [" + ctx + "]");
        }
        if (ctx == null) {
            throw new IllegalStateException("Null context not allowed!!");
        }
        if (ctx.hasFlag(Flag.FAIL_SILENTLY)) {
            suppressExceptions = true;
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable th) {
            for (Object key : ctx.getKeysAddedInCurrentInvocation()) {
                if (!ctx.hasLockedKey(key)) continue;
                if (suppressExceptions) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Caught exception, Releasing lock on key " + key + " acquired during the current invocation!");
                    }
                } else if (this.log.isInfoEnabled()) {
                    this.log.info("Caught exception, Releasing lock on key " + key + " acquired during the current invocation!");
                }
                this.lockManager.unlock(key);
                ctx.removeLookedUpEntry(key);
            }
            if (suppressExceptions) {
                this.log.trace((Object)"Exception while executing code, failing silently...", th);
                Object var5_6 = null;
                return var5_6;
            }
            this.log.error((Object)"Execution error: ", th);
            throw th;
        }
        finally {
            ctx.reset();
        }
    }
}

