/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.Immutables;

public class MarshalledValueInterceptor
extends CommandInterceptor {
    private StreamingMarshaller marshaller;

    @Inject
    protected void injectMarshaller(StreamingMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (command.multipleKeys()) {
            Set<Object> rawKeys = command.getKeys();
            HashMap<Object, Object> keyToMarshalledKeyMapping = new HashMap<Object, Object>(rawKeys.size());
            for (Object e : rawKeys) {
                if (MarshalledValue.isTypeExcluded(e.getClass())) continue;
                keyToMarshalledKeyMapping.put(e, this.createMarshalledValue(e, ctx));
            }
            if (!keyToMarshalledKeyMapping.isEmpty()) {
                command.replaceKeys(keyToMarshalledKeyMapping);
            }
        } else {
            Object key = command.getSingleKey();
            if (!MarshalledValue.isTypeExcluded(key.getClass())) {
                command.replaceKey(key, this.createMarshalledValue(key, ctx));
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>();
        Map map = this.wrapMap(command.getMap(), marshalledValues, ctx);
        command.setMap(map);
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.compactAndProcessRetVal(marshalledValues, retVal);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        MarshalledValue key = null;
        MarshalledValue value = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (!MarshalledValue.isTypeExcluded(command.getValue().getClass())) {
            value = this.createMarshalledValue(command.getValue(), ctx);
            command.setValue(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(key);
        this.compact(value);
        return this.processRetVal(retVal);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        MarshalledValue value = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(value);
        return this.processRetVal(retVal);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        MarshalledValue value = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(value);
        return this.processRetVal(retVal);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        MarshalledValue mv = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            mv = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(mv);
            this.compact(mv);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(mv);
        return this.processRetVal(retVal);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        Set keys = (Set)this.invokeNextInterceptor(ctx, command);
        HashSet copy = new HashSet(keys.size());
        for (Object key : keys) {
            if (key instanceof MarshalledValue) {
                key = ((MarshalledValue)key).get();
            }
            copy.add(key);
        }
        return Immutables.immutableSetWrap(copy);
    }

    @Override
    public Object visitValuesCommand(InvocationContext ctx, ValuesCommand command) throws Throwable {
        Collection values = (Collection)this.invokeNextInterceptor(ctx, command);
        ArrayList copy = new ArrayList();
        for (Object value : values) {
            if (value instanceof MarshalledValue) {
                value = ((MarshalledValue)value).get();
            }
            copy.add(value);
        }
        return Immutables.immutableCollectionWrap(copy);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        Set entries = (Set)this.invokeNextInterceptor(ctx, command);
        HashSet<InternalCacheEntry> copy = new HashSet<InternalCacheEntry>(entries.size());
        for (InternalCacheEntry entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof MarshalledValue) {
                key = ((MarshalledValue)key).get();
            }
            if (value instanceof MarshalledValue) {
                value = ((MarshalledValue)value).get();
            }
            InternalCacheEntry newEntry = Immutables.immutableInternalCacheEntry(InternalEntryFactory.create(key, value, entry.getCreated(), entry.getLifespan(), entry.getLastUsed(), entry.getMaxIdle()));
            copy.add(newEntry);
        }
        return Immutables.immutableSetWrap(copy);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        MarshalledValue key = null;
        MarshalledValue newValue = null;
        MarshalledValue oldValue = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (!MarshalledValue.isTypeExcluded(command.getNewValue().getClass())) {
            newValue = this.createMarshalledValue(command.getNewValue(), ctx);
            command.setNewValue(newValue);
        }
        if (command.getOldValue() != null && !MarshalledValue.isTypeExcluded(command.getOldValue().getClass())) {
            oldValue = this.createMarshalledValue(command.getOldValue(), ctx);
            command.setOldValue(oldValue);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(key);
        this.compact(newValue);
        this.compact(oldValue);
        return this.processRetVal(retVal);
    }

    private Object compactAndProcessRetVal(Set<MarshalledValue> marshalledValues, Object retVal) throws IOException, ClassNotFoundException {
        if (this.trace) {
            this.log.trace("Compacting MarshalledValues created");
        }
        for (MarshalledValue mv : marshalledValues) {
            this.compact(mv);
        }
        return this.processRetVal(retVal);
    }

    private void compact(MarshalledValue mv) {
        if (mv == null) {
            return;
        }
        mv.compact(false, false);
    }

    private Object processRetVal(Object retVal) throws IOException, ClassNotFoundException {
        if (retVal instanceof MarshalledValue) {
            if (this.trace) {
                this.log.trace((Object)"Return is a marshall value, so extract instance from: {0}", retVal);
            }
            retVal = ((MarshalledValue)retVal).get();
        }
        return retVal;
    }

    protected Map wrapMap(Map<Object, Object> m, Set<MarshalledValue> marshalledValues, InvocationContext ctx) throws NotSerializableException {
        if (m == null) {
            if (this.trace) {
                this.log.trace("Map is nul; returning an empty map.");
            }
            return Collections.emptyMap();
        }
        if (this.trace) {
            this.log.trace("Wrapping map contents of argument " + m);
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> me : m.entrySet()) {
            Object newValue;
            Object key = me.getKey();
            Object value = me.getValue();
            Object newKey = key == null || MarshalledValue.isTypeExcluded(key.getClass()) ? key : this.createMarshalledValue(key, ctx);
            Object object = newValue = value == null || MarshalledValue.isTypeExcluded(value.getClass()) ? value : this.createMarshalledValue(value, ctx);
            if (newKey instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newKey);
            }
            if (newValue instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newValue);
            }
            copy.put(newKey, newValue);
        }
        return copy;
    }

    protected MarshalledValue createMarshalledValue(Object toWrap, InvocationContext ctx) throws NotSerializableException {
        return new MarshalledValue(toWrap, ctx.isOriginLocal(), this.marshaller);
    }
}

