/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Set;
import javax.management.MBeanServer;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractJmxRegistration {
    private static final Log log = LogFactory.getLog(AbstractJmxRegistration.class);
    String jmxDomain;
    MBeanServer mBeanServer;
    GlobalConfiguration globalConfig;

    protected abstract ComponentsJmxRegistration buildRegistrar(Set<AbstractComponentRegistry.Component> var1);

    protected void registerMBeans(Set<AbstractComponentRegistry.Component> components, GlobalConfiguration globalConfig) {
        this.mBeanServer = this.getMBeanServer(globalConfig);
        ComponentsJmxRegistration registrar = this.buildRegistrar(components);
        registrar.registerMBeans();
    }

    protected void unregisterMBeans(Set<AbstractComponentRegistry.Component> components) {
        ComponentsJmxRegistration registrar = this.buildRegistrar(components);
        registrar.unregisterMBeans();
    }

    protected MBeanServer getMBeanServer(GlobalConfiguration configuration) {
        String serverLookup = configuration.getMBeanServerLookup();
        MBeanServerLookup lookup = (MBeanServerLookup)Util.getInstance(serverLookup);
        return lookup.getMBeanServer();
    }

    protected String getJmxDomain(String jmxDomain, MBeanServer mBeanServer) {
        String[] registeredDomains = mBeanServer.getDomains();
        int index = 2;
        String finalName = jmxDomain;
        boolean done = false;
        block0: while (!done) {
            done = true;
            for (String domain : registeredDomains) {
                if (!domain.equals(finalName)) continue;
                finalName = jmxDomain + index++;
                done = false;
                continue block0;
            }
        }
        return finalName;
    }
}

