/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.util.AbstractMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.ReversibleOrderedSet;

public class BidirectionalLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements BidirectionalMap<K, V>,
Cloneable {
    private transient LinkedEntry<K, V> header;
    private final boolean accessOrder;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient LinkedEntry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;

    public BidirectionalLinkedHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public BidirectionalLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new LinkedEntry[capacity];
        this.accessOrder = accessOrder;
        this.init();
    }

    public BidirectionalLinkedHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public BidirectionalLinkedHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new LinkedEntry[16];
        this.accessOrder = false;
        this.init();
    }

    public BidirectionalLinkedHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, false);
        super.putAllForCreate(m);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    final LinkedEntry<K, V> getEntry(Object key) {
        int hash = key == null ? 0 : BidirectionalLinkedHashMap.hash(key);
        LinkedEntry e = this.table[BidirectionalLinkedHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.assertKeyNotNull(key);
        int hash = BidirectionalLinkedHashMap.hash(key);
        int i = BidirectionalLinkedHashMap.indexFor(hash, this.table.length);
        LinkedEntry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    private void putForCreate(K key, V value) {
        int hash = key == null ? 0 : BidirectionalLinkedHashMap.hash(key);
        int i = BidirectionalLinkedHashMap.indexFor(hash, this.table.length);
        LinkedEntry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        LinkedEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        LinkedEntry[] newTable = new LinkedEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.assertKeyNotNull(key);
        LinkedEntry<K, V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    final LinkedEntry<K, V> removeEntryForKey(Object key) {
        LinkedEntry prev;
        int hash = BidirectionalLinkedHashMap.hash(key);
        int i = BidirectionalLinkedHashMap.indexFor(hash, this.table.length);
        LinkedEntry e = prev = this.table[i];
        while (e != null) {
            Object k;
            LinkedEntry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final LinkedEntry<K, V> removeMapping(Object o) {
        LinkedEntry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : BidirectionalLinkedHashMap.hash(key);
        int i = BidirectionalLinkedHashMap.indexFor(hash, this.table.length);
        LinkedEntry e = prev = this.table[i];
        while (e != null) {
            LinkedEntry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        LinkedEntry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    void init() {
        this.header = new LinkedEntry<Object, Object>(-1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    void transfer(LinkedEntry[] newTable) {
        int newCapacity = newTable.length;
        LinkedEntry e = this.header.after;
        while (e != this.header) {
            int index = BidirectionalLinkedHashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            LinkedEntry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            LinkedEntry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        this.assertKeyNotNull(key);
        LinkedEntry<K, V> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return e.value;
    }

    void addEntry(int hash, K key, V value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        LinkedEntry<K, V> e;
        LinkedEntry old = this.table[bucketIndex];
        this.table[bucketIndex] = e = new LinkedEntry<K, V>(hash, key, value, old);
        ((LinkedEntry)e).addBefore((LinkedEntry)this.header);
        ++this.size;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public ReversibleOrderedSet<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return (ReversibleOrderedSet)this.keySet;
    }

    @Override
    public ReversibleOrderedSet<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return (ReversibleOrderedSet)this.entrySet;
    }

    public BidirectionalLinkedHashMap clone() {
        BidirectionalLinkedHashMap result;
        try {
            result = (BidirectionalLinkedHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen!", e);
        }
        result.table = new LinkedEntry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements ReversibleOrderedSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> reverseIterator() {
            return new EntryIterator(true);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(false);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            LinkedEntry candidate = BidirectionalLinkedHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return BidirectionalLinkedHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return BidirectionalLinkedHashMap.this.size;
        }

        @Override
        public void clear() {
            BidirectionalLinkedHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K>
    implements ReversibleOrderedSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> reverseIterator() {
            return new KeyIterator(true);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(false);
        }

        @Override
        public void clear() {
            BidirectionalLinkedHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return BidirectionalLinkedHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int size = this.size();
            BidirectionalLinkedHashMap.this.remove(o);
            return this.size() < size;
        }

        @Override
        public int size() {
            return BidirectionalLinkedHashMap.this.size();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(false);
        }

        @Override
        public int size() {
            return BidirectionalLinkedHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return BidirectionalLinkedHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            BidirectionalLinkedHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        protected EntryIterator(boolean directionReversed) {
            super(directionReversed);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator<V> {
        protected ValueIterator(boolean directionReversed) {
            super(directionReversed);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIterator<K> {
        protected KeyIterator(boolean directionReversed) {
            super(directionReversed);
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        LinkedEntry<K, V> nextEntry;
        LinkedEntry<K, V> lastReturned = null;
        boolean directionReversed;
        int expectedModCount;

        protected LinkedHashIterator(boolean directionReversed) {
            this.expectedModCount = BidirectionalLinkedHashMap.this.modCount;
            this.directionReversed = directionReversed;
            this.nextEntry = directionReversed ? ((BidirectionalLinkedHashMap)BidirectionalLinkedHashMap.this).header.before : ((BidirectionalLinkedHashMap)BidirectionalLinkedHashMap.this).header.after;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != BidirectionalLinkedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (BidirectionalLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            BidirectionalLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = BidirectionalLinkedHashMap.this.modCount;
        }

        LinkedEntry<K, V> nextEntry() {
            if (BidirectionalLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == BidirectionalLinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            LinkedEntry e = this.lastReturned;
            this.nextEntry = this.directionReversed ? e.before : e.after;
            return e;
        }
    }

    static class LinkedEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        LinkedEntry<K, V> next;
        final int hash;
        LinkedEntry<K, V> before;
        LinkedEntry<K, V> after;

        LinkedEntry(int h, K k, V v, LinkedEntry<K, V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(LinkedEntry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        void recordAccess(BidirectionalLinkedHashMap<K, V> lm) {
            if (((BidirectionalLinkedHashMap)lm).accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(((BidirectionalLinkedHashMap)lm).header);
            }
        }

        void recordRemoval(BidirectionalLinkedHashMap<K, V> m) {
            this.remove();
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

