/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMapDelta;
import org.infinispan.atomic.AtomicHashMapProxy;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.ClearOperation;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.NullDelta;
import org.infinispan.atomic.PutOperation;
import org.infinispan.atomic.RemoveOperation;
import org.infinispan.batch.BatchContainer;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.FastCopyHashMap;
import org.infinispan.util.Util;

@NotThreadSafe
public class AtomicHashMap<K, V>
implements AtomicMap<K, V>,
DeltaAware,
Cloneable {
    FastCopyHashMap<K, V> delegate;
    private AtomicHashMapDelta delta = null;
    private volatile AtomicHashMapProxy<K, V> proxy;
    volatile boolean copied = false;

    public static <K, V> AtomicHashMap<K, V> newInstance(Cache cache, Object cacheKey) {
        AtomicHashMap<K, V> value = new AtomicHashMap<K, V>();
        AtomicHashMap<K, V> oldValue = cache.putIfAbsent(cacheKey, value);
        if (oldValue != null) {
            value = oldValue;
        }
        return value;
    }

    public AtomicHashMap() {
        this.delegate = new FastCopyHashMap();
    }

    private AtomicHashMap(FastCopyHashMap<K, V> delegate) {
        this.delegate = delegate;
    }

    public AtomicHashMap(boolean isCopy) {
        this();
        this.copied = isCopy;
    }

    @Override
    public void commit() {
        this.copied = false;
        this.delta = null;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.delegate.put(key, value);
        PutOperation<K, V> op = new PutOperation<K, V>(key, oldValue, value);
        this.getDelta().addOperation(op);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.delegate.remove(key);
        RemoveOperation<Object, V> op = new RemoveOperation<Object, V>(key, oldValue);
        this.getDelta().addOperation(op);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        FastCopyHashMap originalEntries = (FastCopyHashMap)this.delegate.clone();
        ClearOperation op = new ClearOperation(originalEntries);
        if (this.delta != null) {
            this.delta.addOperation(op);
        }
        this.delegate.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AtomicMap<K, V> getProxy(Cache cache, Object mapKey, BatchContainer batchContainer, InvocationContextContainer icc) {
        if (this.proxy == null) {
            AtomicHashMap atomicHashMap = this;
            synchronized (atomicHashMap) {
                if (this.proxy == null) {
                    this.proxy = new AtomicHashMapProxy(cache, mapKey, batchContainer, icc);
                }
            }
        }
        return this.proxy;
    }

    @Override
    public Delta delta() {
        Delta toReturn = this.delta == null ? NullDelta.INSTANCE : this.delta;
        this.delta = null;
        return toReturn;
    }

    public AtomicHashMap<K, V> copyForWrite() {
        try {
            AtomicHashMap clone = (AtomicHashMap)super.clone();
            clone.delegate = (FastCopyHashMap)this.delegate.clone();
            clone.proxy = this.proxy;
            clone.copied = true;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "AtomicHashMap{delegate=" + this.delegate + '}';
    }

    public void initForWriting() {
        this.delta = new AtomicHashMapDelta();
    }

    private AtomicHashMapDelta getDelta() {
        if (this.delta == null) {
            this.delta = new AtomicHashMapDelta();
        }
        return this.delta;
    }

    public static class Externalizer
    extends AbstractExternalizer<AtomicHashMap> {
        @Override
        public void writeObject(ObjectOutput output, AtomicHashMap map) throws IOException {
            output.writeObject(map.delegate);
        }

        @Override
        public AtomicHashMap readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            FastCopyHashMap delegate = (FastCopyHashMap)input.readObject();
            return new AtomicHashMap(delegate);
        }

        @Override
        public Integer getId() {
            return 20;
        }

        @Override
        public Set<Class<? extends AtomicHashMap>> getTypeClasses() {
            return Util.asSet(AtomicHashMap.class);
        }
    }
}

