/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.RemoveRecoveryInfoCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    Transport transport;
    EmbeddedCacheManager cacheManager;
    GlobalComponentRegistry registry;
    Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(Transport transport, EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.transport = transport;
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters) {
        ReplicableCommand command;
        switch (id) {
            case 8: {
                command = new PutKeyValueCommand();
                break;
            }
            case 3: {
                command = new LockControlCommand();
                break;
            }
            case 9: {
                command = new PutMapCommand();
                break;
            }
            case 10: {
                command = new RemoveCommand();
                break;
            }
            case 11: {
                command = new ReplaceCommand();
                break;
            }
            case 4: {
                command = new GetKeyValueCommand();
                break;
            }
            case 5: {
                command = new ClearCommand();
                break;
            }
            case 12: {
                command = new PrepareCommand();
                break;
            }
            case 14: {
                command = new CommitCommand();
                break;
            }
            case 13: {
                command = new RollbackCommand();
                break;
            }
            case 2: {
                command = new MultipleRpcCommand();
                break;
            }
            case 1: {
                command = new SingleRpcCommand();
                break;
            }
            case 6: {
                command = new InvalidateCommand();
                break;
            }
            case 7: {
                command = new InvalidateL1Command();
                break;
            }
            case 15: {
                command = new StateTransferControlCommand();
                ((StateTransferControlCommand)command).init(this.transport);
                break;
            }
            case 16: {
                command = new ClusteredGetCommand();
                break;
            }
            case 17: {
                command = new RehashControlCommand(this.transport);
                break;
            }
            case 18: {
                command = new RemoveCacheCommand(this.cacheManager, this.registry);
                break;
            }
            case 65: {
                command = new RemoveRecoveryInfoCommand();
                break;
            }
            case 64: {
                command = new GetInDoubtTransactionsCommand();
                break;
            }
            default: {
                ModuleCommandFactory mcf = this.commandFactories.get(id);
                if (mcf != null) {
                    return mcf.fromStream(id, parameters);
                }
                throw new CacheException("Unknown command id " + id + "!");
            }
        }
        command.setParameters(id, parameters);
        return command;
    }
}

