/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.MarshallUtil;
import org.infinispan.util.ImmutableListCopy;
import org.infinispan.util.ObjectDuplicator;
import org.infinispan.util.ReversibleOrderedSet;
import org.infinispan.util.Util;
import org.infinispan.util.VisitableBidirectionalLinkedHashSet;

public class Immutables {
    public static boolean isImmutable(Object o) {
        return o instanceof Immutable;
    }

    public static <T> List<T> immutableListConvert(Collection<? extends T> source) {
        return new ImmutableListCopy<T>(source);
    }

    public static <T> List<T> immutableListCopy(List<? extends T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return new ImmutableListCopy<T>(list);
    }

    public static <T> List<T> immutableListWrap(T ... array) {
        return new ImmutableListCopy<T>(array);
    }

    public static <T> List<T> immutableListMerge(List<? extends T> list1, List<? extends T> list2) {
        return new ImmutableListCopy<T>(list1, list2);
    }

    public static <T> Set<T> immutableSetConvert(Collection<? extends T> collection) {
        return Immutables.immutableSetWrap(new HashSet<T>(collection));
    }

    public static <T> Set<T> immutableSetWrap(Set<? extends T> set) {
        return new ImmutableSetWrapper<T>(set);
    }

    public static <T> Set<T> immutableSetCopy(Set<? extends T> set) {
        if (set == null) {
            return null;
        }
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        HashSet<? extends T> copy = ObjectDuplicator.duplicateSet(set);
        if (copy == null) {
            copy = (HashSet<? extends T>)Immutables.attemptCopyConstructor(set, Collection.class);
        }
        if (copy == null) {
            copy = new HashSet<T>(set);
        }
        return new ImmutableSetWrapper(copy);
    }

    public static <K, V> Map<K, V> immutableMapWrap(Map<? extends K, ? extends V> map) {
        return new ImmutableMapWrapper<K, V>(map);
    }

    public static <K, V> Map<K, V> immutableMapCopy(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> me = map.entrySet().iterator().next();
            return Collections.singletonMap(me.getKey(), me.getValue());
        }
        HashMap<? extends K, ? extends V> copy = ObjectDuplicator.duplicateMap(map);
        if (copy == null) {
            copy = Immutables.attemptCopyConstructor(map, Map.class);
        }
        if (copy == null) {
            copy = new HashMap<K, V>(map);
        }
        return new ImmutableMapWrapper(copy);
    }

    public static <T> Collection<T> immutableCollectionCopy(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        if (collection.size() == 1) {
            return Collections.singleton(collection.iterator().next());
        }
        ArrayList<? extends T> copy = ObjectDuplicator.duplicateCollection(collection);
        if (copy == null) {
            copy = Immutables.attemptCopyConstructor(collection, Collection.class);
        }
        if (copy == null) {
            copy = new ArrayList<T>(collection);
        }
        return new ImmutableCollectionWrapper(copy);
    }

    public static <T> Collection<T> immutableCollectionWrap(Collection<? extends T> collection) {
        return new ImmutableCollectionWrapper<T>(collection);
    }

    private static <T> T attemptCopyConstructor(T source, Class<? super T> clazz) {
        try {
            return (T)source.getClass().getConstructor(clazz).newInstance(source);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> ReversibleOrderedSet<T> immutableReversibleOrderedSetCopy(ReversibleOrderedSet<T> set) {
        VisitableBidirectionalLinkedHashSet<T> copy = ObjectDuplicator.duplicateSet(set);
        if (copy == null) {
            copy = (VisitableBidirectionalLinkedHashSet<T>)Immutables.attemptCopyConstructor(set, ReversibleOrderedSet.class);
        }
        if (copy == null) {
            copy = new VisitableBidirectionalLinkedHashSet<T>(false, set);
        }
        return new ImmutableReversibleOrderedSetWrapper(copy);
    }

    public static <K, V> Map.Entry<K, V> immutableEntry(Map.Entry<K, V> entry) {
        return new ImmutableEntry<K, V>(entry);
    }

    public static InternalCacheEntry immutableInternalCacheEntry(InternalCacheEntry entry) {
        return new ImmutableInternalCacheEntry(entry);
    }

    public static class ImmutableMapWrapperExternalizer
    extends AbstractExternalizer<Map> {
        @Override
        public void writeObject(ObjectOutput output, Map map) throws IOException {
            MarshallUtil.marshallMap(map, output);
        }

        @Override
        public Map readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            HashMap map = new HashMap();
            MarshallUtil.unmarshallMap(map, input);
            return Immutables.immutableMapWrap(map);
        }

        @Override
        public Integer getId() {
            return 19;
        }

        @Override
        public Set<Class<? extends Map>> getTypeClasses() {
            return Util.asSet(ImmutableMapWrapper.class);
        }
    }

    private static class ImmutableMapWrapper<K, V>
    implements Map<K, V>,
    Serializable,
    Immutable {
        private static final long serialVersionUID = 708144227046742221L;
        private Map<? extends K, ? extends V> map;

        public ImmutableMapWrapper(Map<? extends K, ? extends V> map) {
            this.map = map;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new ImmutableEntrySetWrapper<K, V>(this.map.entrySet());
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.map).equals(o);
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public int hashCode() {
            return ((Object)this.map).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return new ImmutableSetWrapper<K>(this.map.keySet());
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<V> values() {
            return new ImmutableCollectionWrapper<V>(this.map.values());
        }

        public String toString() {
            return this.map.toString();
        }
    }

    private static class ImmutableEntrySetWrapper<K, V>
    extends ImmutableSetWrapper<Map.Entry<K, V>> {
        private static final long serialVersionUID = 6378667653889667692L;

        public ImmutableEntrySetWrapper(Set<? extends Map.Entry<? extends K, ? extends V>> set) {
            super(set);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.collection.size()];
            int i = 0;
            for (Map.Entry<K, V> entry : this) {
                array[i++] = entry;
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.collection.size();
            if (array.length < size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            }
            int i = 0;
            T[] result = array;
            for (Map.Entry<K, V> entry : this) {
                result[i++] = entry;
            }
            return array;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ImmutableIteratorWrapper<Map.Entry<K, V>>(this.collection.iterator()){

                @Override
                public Map.Entry<K, V> next() {
                    return new ImmutableEntry((Map.Entry)super.next());
                }
            };
        }
    }

    private static class ImmutableInternalCacheValue
    implements InternalCacheValue,
    Immutable {
        private final ImmutableInternalCacheEntry entry;

        ImmutableInternalCacheValue(ImmutableInternalCacheEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean canExpire() {
            return this.entry.canExpire();
        }

        @Override
        public long getCreated() {
            return this.entry.getCreated();
        }

        @Override
        public long getLastUsed() {
            return this.entry.getLastUsed();
        }

        @Override
        public long getLifespan() {
            return this.entry.getLifespan();
        }

        @Override
        public long getMaxIdle() {
            return this.entry.getMaxIdle();
        }

        @Override
        public Object getValue() {
            return this.entry.getValue();
        }

        @Override
        public boolean isExpired() {
            return this.entry.isExpired();
        }

        @Override
        public InternalCacheEntry toInternalCacheEntry(Object key) {
            return this.entry;
        }
    }

    private static class ImmutableInternalCacheEntry
    implements InternalCacheEntry,
    Immutable {
        private final InternalCacheEntry entry;
        private final int hash;

        ImmutableInternalCacheEntry(InternalCacheEntry entry) {
            this.entry = entry;
            this.hash = entry.hashCode();
        }

        @Override
        public Object getKey() {
            return this.entry.getKey();
        }

        @Override
        public Object getValue() {
            return this.entry.getValue();
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof InternalCacheEntry)) {
                return false;
            }
            InternalCacheEntry entry = (InternalCacheEntry)o;
            return entry.equals(this.entry);
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean canExpire() {
            return this.entry.canExpire();
        }

        @Override
        public long getCreated() {
            return this.entry.getCreated();
        }

        @Override
        public long getExpiryTime() {
            return this.entry.getExpiryTime();
        }

        @Override
        public long getLastUsed() {
            return this.entry.getLastUsed();
        }

        @Override
        public boolean isExpired() {
            return this.entry.isExpired();
        }

        @Override
        public void setLifespan(long lifespan) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMaxIdle(long maxIdle) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalCacheValue toInternalCacheValue() {
            return new ImmutableInternalCacheValue(this);
        }

        @Override
        public void touch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reincarnate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void commit(DataContainer container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLifespan() {
            return this.entry.getLifespan();
        }

        @Override
        public long getMaxIdle() {
            return this.entry.getMaxIdle();
        }

        @Override
        public boolean isChanged() {
            return this.entry.isChanged();
        }

        @Override
        public boolean isCreated() {
            return this.entry.isCreated();
        }

        @Override
        public boolean isNull() {
            return this.entry.isNull();
        }

        @Override
        public boolean isRemoved() {
            return this.entry.isRemoved();
        }

        @Override
        public boolean isValid() {
            return this.entry.isValid();
        }

        @Override
        public void rollback() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCreated(boolean created) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRemoved(boolean removed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValid(boolean valid) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLockPlaceholder() {
            return this.entry.isLockPlaceholder();
        }

        @Override
        public InternalCacheEntry clone() {
            return new ImmutableInternalCacheEntry(this.entry.clone());
        }
    }

    private static class ImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Immutable {
        private K key;
        private V value;
        private int hash;

        ImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
            this.hash = ((Object)entry).hashCode();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ImmutableEntry.eq(entry.getKey(), this.key) && ImmutableEntry.eq(entry.getValue(), this.value);
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private static class ImmutableReversibleOrderedSetWrapper<E>
    extends ImmutableCollectionWrapper<E>
    implements ReversibleOrderedSet<E>,
    Serializable,
    Immutable {
        private static final long serialVersionUID = 7991492805176142615L;

        public ImmutableReversibleOrderedSetWrapper(Set<? extends E> set) {
            super(set);
        }

        @Override
        public Iterator<E> reverseIterator() {
            return new ImmutableIteratorWrapper(((ReversibleOrderedSet)this.collection).reverseIterator());
        }
    }

    private static class ImmutableSetWrapper<E>
    extends ImmutableCollectionWrapper<E>
    implements Set<E>,
    Serializable,
    Immutable {
        private static final long serialVersionUID = 7991492805176142615L;

        public ImmutableSetWrapper(Set<? extends E> set) {
            super(set);
        }
    }

    private static class ImmutableCollectionWrapper<E>
    implements Collection<E>,
    Serializable,
    Immutable {
        private static final long serialVersionUID = 6777564328198393535L;
        Collection<? extends E> collection;

        public ImmutableCollectionWrapper(Collection<? extends E> collection) {
            this.collection = collection;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.collection.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.collection).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.collection).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new ImmutableIteratorWrapper<E>(this.collection.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.collection.toArray(a);
        }

        public String toString() {
            return this.collection.toString();
        }
    }

    private static class ImmutableIteratorWrapper<E>
    implements Iterator<E> {
        private Iterator<? extends E> iterator;

        public ImmutableIteratorWrapper(Iterator<? extends E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Immutable {
    }
}

