/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009 Red Hat Inc. and/or its affiliates and other
 * contributors as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.infinispan.commands.remote;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;

/**
 * The {@link org.infinispan.remoting.rpc.RpcManager} only replicates commands wrapped in a {@link CacheRpcCommand}.
 *
 * @author Manik Surtani
 * @author Mircea.Markus@jboss.com
 * @since 4.0
 */
public interface CacheRpcCommand extends ReplicableCommand {

   /**
    * @return the name of the cache that produced this command.  This will also be the name of the cache this command is
    *         intended for.
    */
   String getCacheName();

   /**
    * Sets up some more context for the invocation of this command, so that these components wouldn't need to be looked
    * up again later.
    * @param cfg configuration of the named cache associated with this command
    * @param cr component registry of the named cache associated with this command
    */
   void injectComponents(Configuration cfg, ComponentRegistry cr);

   /**
    * Retrieves the configuration associated with this command
    * @return a Configuration instance
    */
   Configuration getConfiguration();

   /**
    * Retrieves the component registry associated with this command
    * @return a component registry
    */
   ComponentRegistry getComponentRegistry();
   
   /**
    * Set the origin of the command
    * @param origin
    */
   void setOrigin(Address origin);
   
   /**
    * Get the origin of the command
    * @return
    */
   Address getOrigin();
   
}
