/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009 Red Hat Inc. and/or its affiliates and other
 * contributors as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.infinispan.factories;

import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.statetransfer.DistributedStateTransferManagerImpl;
import org.infinispan.statetransfer.DummyInvalidationStateTransferManagerImpl;
import org.infinispan.statetransfer.ReplicatedStateTransferManagerImpl;
import org.infinispan.statetransfer.StateTransferManager;

/**
 * Constructs {@link org.infinispan.statetransfer.StateTransferManager} instances.
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @author Dan Berindei &lt;dan@infinispan.org&gt;
 * @since 4.0
 */
@DefaultFactoryFor(classes = StateTransferManager.class)
public class StateTransferManagerFactory extends AbstractNamedCacheComponentFactory implements AutoInstantiableFactory {
   public <T> T construct(Class<T> componentType) {
      if (!configuration.getCacheMode().isClustered())
         return null;

      if (configuration.getCacheMode().isDistributed())
         return componentType.cast(new DistributedStateTransferManagerImpl());
      else if (configuration.getCacheMode().isReplicated())
         return componentType.cast(new ReplicatedStateTransferManagerImpl());
      else if (configuration.getCacheMode().isInvalidation())
         return componentType.cast(new DummyInvalidationStateTransferManagerImpl());
      else
         return null;
   }
}
