/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.batch;

import net.jcip.annotations.NotThreadSafe;
import org.infinispan.batch.BatchContainer;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;

@NotThreadSafe
public abstract class AutoBatchSupport {
    protected BatchContainer batchContainer;

    protected void assertBatchingSupported(Configuration c) {
        if (!c.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
    }

    protected void startAtomic() {
        this.batchContainer.startBatch(true);
    }

    protected void endAtomic() {
        this.batchContainer.endBatch(true, true);
    }
}

