/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.Collection;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferControlCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 15;
    Type type;
    Address sender;
    int viewId;
    Collection<InternalCacheEntry> state;
    StateTransferManager stateTransferManager;
    Configuration configuration;
    DataContainer dataContainer;
    CommandsFactory commandsFactory;
    private static final Log log = LogFactory.getLog(StateTransferControlCommand.class);

    public StateTransferControlCommand() {
        super(null);
    }

    public StateTransferControlCommand(String cacheName) {
        super(cacheName);
    }

    public StateTransferControlCommand(String cacheName, Type type, Address sender, int viewId, Collection<InternalCacheEntry> state) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
        this.state = state;
    }

    public StateTransferControlCommand(String cacheName, Type type, Address sender, int viewId) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
    }

    public void init(StateTransferManager stateTransferManager, Configuration configuration, DataContainer dataContainer, CommandsFactory commandsFactory) {
        this.stateTransferManager = stateTransferManager;
        this.configuration = configuration;
        this.dataContainer = dataContainer;
        this.commandsFactory = commandsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.configuration.getName(), trace);
        this.stateTransferManager.waitForJoinToStart();
        try {
            switch (this.type) {
                case APPLY_STATE: {
                    this.stateTransferManager.applyState(this.state, this.sender, this.viewId);
                    Object var3_3 = null;
                    return var3_3;
                }
            }
            try {
                throw new CacheException("Unknown rehash control command type " + (Object)((Object)this.type));
            }
            catch (Throwable t) {
                log.exceptionHandlingCommand(this, t);
                Object var4_5 = null;
                return var4_5;
            }
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public byte getCommandId() {
        return 15;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{(byte)this.type.ordinal(), this.sender, this.viewId, this.state};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.type = Type.values()[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.viewId = (Integer)parameters[i++];
        this.state = (Collection)parameters[i++];
    }

    @Override
    public String toString() {
        return "StateTransferControlCommand{cache=" + this.cacheName + ", type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", viewId=" + this.viewId + ", state=" + (this.state == null ? "N/A" : Integer.valueOf(this.state.size())) + '}';
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public static enum Type {
        APPLY_STATE;

    }
}

