/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.lifecycle.ComponentStatus;

public class DistributedExecuteCommand<V>
implements VisitableCommand {
    public static final int COMMAND_ID = 19;
    private static final long serialVersionUID = -7828117401763700385L;
    protected Cache cache;
    protected Set<Object> keys;
    protected Callable<V> callable;

    public DistributedExecuteCommand(Collection<Object> inputKeys, Callable<V> callable) {
        this.keys = inputKeys == null || inputKeys.isEmpty() ? new HashSet<Object>() : new HashSet<Object>(inputKeys);
        this.callable = callable;
    }

    public DistributedExecuteCommand() {
        this(null, null);
    }

    public void init(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitDistributedExecuteCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public Object perform(InvocationContext context) throws Throwable {
        Callable<V> callable = this.getCallable();
        if (callable instanceof DistributedCallable) {
            DistributedCallable dc = (DistributedCallable)callable;
            dc.setEnvironment(this.cache, this.keys);
        }
        return callable.call();
    }

    private Callable<V> getCallable() {
        return this.callable;
    }

    @Override
    public byte getCommandId() {
        return 19;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.callable};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 19) {
            throw new IllegalStateException("Invalid method id");
        }
        int i = 0;
        this.keys = (Set)args[i++];
        this.callable = (Callable)args[i++];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DistributedExecuteCommand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DistributedExecuteCommand that = (DistributedExecuteCommand)o;
        return !((Object)this.keys).equals(that.keys);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keys != null ? ((Object)this.keys).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DistributedExecuteCommand{cache=" + this.cache + ", keys=" + this.keys + ", callable=" + this.callable + '}';
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

