/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.util.Immutables;

public class EntrySetCommand
extends AbstractLocalCommand
implements VisitableCommand {
    private final DataContainer container;
    private final InternalEntryFactory entryFactory;

    public EntrySetCommand(DataContainer container, InternalEntryFactory internalEntryFactory) {
        this.container = container;
        this.entryFactory = internalEntryFactory;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEntrySetCommand(ctx, this);
    }

    @Override
    public Set<InternalCacheEntry> perform(InvocationContext ctx) throws Throwable {
        Set<InternalCacheEntry> entries = this.container.entrySet();
        if (this.noTxModifications(ctx)) {
            return new ExpiredFilteredEntrySet(entries);
        }
        return new FilteredEntrySet(entries, ctx.getLookedUpEntries());
    }

    public String toString() {
        return "EntrySetCommand{set=" + this.container.entrySet() + '}';
    }

    private static class ExpiredFilteredEntrySet
    extends AbstractSet<InternalCacheEntry> {
        final Set<InternalCacheEntry> entrySet;

        public ExpiredFilteredEntrySet(Set<InternalCacheEntry> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new Itr();
        }

        @Override
        public int size() {
            int s = this.entrySet.size();
            long currentTimeMillis = System.currentTimeMillis();
            for (InternalCacheEntry e : this.entrySet) {
                if (!e.isExpired(currentTimeMillis)) continue;
                --s;
            }
            return s;
        }

        @Override
        public boolean add(InternalCacheEntry e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends InternalCacheEntry> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private class Itr
        implements Iterator<InternalCacheEntry> {
            private final Iterator<InternalCacheEntry> it;
            private InternalCacheEntry next;

            private Itr() {
                this.it = ExpiredFilteredEntrySet.this.entrySet.iterator();
                this.fetchNext();
            }

            private void fetchNext() {
                long currentTimeMillis = System.currentTimeMillis();
                while (this.it.hasNext()) {
                    InternalCacheEntry e = this.it.next();
                    if (e.isExpired(currentTimeMillis)) continue;
                    this.next = e;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public InternalCacheEntry next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                InternalCacheEntry ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class FilteredEntrySet
    extends AbstractSet<InternalCacheEntry> {
        final Set<InternalCacheEntry> entrySet;
        final Map<Object, CacheEntry> lookedUpEntries;

        FilteredEntrySet(Set<InternalCacheEntry> entrySet, Map<Object, CacheEntry> lookedUpEntries) {
            this.entrySet = entrySet;
            this.lookedUpEntries = lookedUpEntries;
        }

        @Override
        public int size() {
            long currentTimeMillis = System.currentTimeMillis();
            int size = this.entrySet.size();
            for (InternalCacheEntry internalCacheEntry : this.entrySet) {
                if (!internalCacheEntry.isExpired(currentTimeMillis)) continue;
                --size;
            }
            for (CacheEntry cacheEntry : this.lookedUpEntries.values()) {
                if (cacheEntry.isCreated()) {
                    ++size;
                    continue;
                }
                if (!cacheEntry.isRemoved()) continue;
                --size;
            }
            return Math.max(size, 0);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            CacheEntry ce = this.lookedUpEntries.get(e.getKey());
            if (ce == null || ce.isRemoved()) {
                return false;
            }
            if (ce.isChanged() || ce.isCreated()) {
                return ce.getValue().equals(e.getValue());
            }
            return this.entrySet.contains(o);
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new Itr();
        }

        @Override
        public boolean add(InternalCacheEntry e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends InternalCacheEntry> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private class Itr
        implements Iterator<InternalCacheEntry> {
            private final Iterator<CacheEntry> it1;
            private final Iterator<InternalCacheEntry> it2;
            private boolean atIt1;
            private InternalCacheEntry next;

            Itr() {
                this.it1 = FilteredEntrySet.this.lookedUpEntries.values().iterator();
                this.it2 = FilteredEntrySet.this.entrySet.iterator();
                this.atIt1 = true;
                this.fetchNext();
            }

            private void fetchNext() {
                boolean found;
                if (this.atIt1) {
                    found = false;
                    while (this.it1.hasNext()) {
                        CacheEntry e = this.it1.next();
                        if (!e.isCreated()) continue;
                        this.next = Immutables.immutableInternalCacheEntry(EntrySetCommand.this.entryFactory.create(e.getKey(), e.getValue(), e.getVersion()));
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.atIt1 = false;
                    }
                }
                if (!this.atIt1) {
                    found = false;
                    long currentTimeMillis = System.currentTimeMillis();
                    while (this.it2.hasNext()) {
                        InternalCacheEntry ice = this.it2.next();
                        Object key = ice.getKey();
                        CacheEntry e = FilteredEntrySet.this.lookedUpEntries.get(key);
                        if (e == null) {
                            this.next = ice;
                            found = true;
                            break;
                        }
                        if (e.isChanged()) {
                            this.next = Immutables.immutableInternalCacheEntry(EntrySetCommand.this.entryFactory.create(key, e.getValue(), e.getVersion()));
                            found = true;
                            break;
                        }
                        if (!e.isRemoved() && !ice.isExpired(currentTimeMillis)) continue;
                    }
                    if (!found) {
                        this.next = null;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public InternalCacheEntry next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                InternalCacheEntry ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

