/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder<L1Configuration> {
    private static final Log log = LogFactory.getLog(L1ConfigurationBuilder.class);
    private boolean enabled = true;
    private int invalidationThreshold = 0;
    private long lifespan = TimeUnit.MINUTES.toMillis(10L);
    private Boolean onRehash = null;

    L1ConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public L1ConfigurationBuilder invalidationThreshold(int invalidationThreshold) {
        this.invalidationThreshold = invalidationThreshold;
        return this;
    }

    public L1ConfigurationBuilder lifespan(long livespan) {
        this.lifespan = livespan;
        return this;
    }

    public L1ConfigurationBuilder enableOnRehash() {
        this.onRehash = true;
        return this;
    }

    public L1ConfigurationBuilder onRehash(boolean enabled) {
        this.onRehash = enabled;
        return this;
    }

    public L1ConfigurationBuilder disableOnRehash() {
        this.onRehash = false;
        return this;
    }

    public L1ConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public L1ConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public L1ConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    void validate() {
        if (!this.enabled && this.onRehash != null && this.onRehash.booleanValue()) {
            throw new ConfigurationException("Can only move entries to L1 on rehash when L1 is enabled");
        }
    }

    @Override
    L1Configuration create() {
        if (!this.enabled && this.onRehash == null) {
            log.debug("L1 is disabled and L1OnRehash was not defined, disabling it");
            this.onRehash = false;
        }
        if (this.onRehash == null) {
            this.onRehash = true;
        }
        return new L1Configuration(this.enabled, this.invalidationThreshold, this.lifespan, this.onRehash);
    }

    public L1ConfigurationBuilder read(L1Configuration template) {
        this.enabled = template.enabled();
        this.invalidationThreshold = template.invalidationThreshold();
        this.lifespan = template.lifespan();
        this.onRehash = template.onRehash();
        return this;
    }
}

