/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.StateRetrievalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateRetrievalConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder<StateRetrievalConfiguration> {
    private static final Log log = LogFactory.getLog(StateRetrievalConfigurationBuilder.class);
    private boolean alwaysProvideInMemoryState = false;
    private Boolean fetchInMemoryState = null;
    private long initialRetryWaitTime = 500L;
    private long logFlushTimeout = TimeUnit.MINUTES.toMillis(1L);
    private int maxNonProgressingLogWrites = 100;
    private int numRetries = 5;
    private int retryWaitTimeIncreaseFactor = 2;
    private long timeout = TimeUnit.MINUTES.toMillis(4L);

    StateRetrievalConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public StateRetrievalConfigurationBuilder alwaysProvideInMemoryState(boolean b) {
        this.alwaysProvideInMemoryState = b;
        return this;
    }

    public StateRetrievalConfigurationBuilder fetchInMemoryState(boolean b) {
        this.fetchInMemoryState = b;
        return this;
    }

    public StateRetrievalConfigurationBuilder initialRetryWaitTime(long l) {
        this.initialRetryWaitTime = l;
        return this;
    }

    public StateRetrievalConfigurationBuilder logFlushTimeout(long l) {
        this.logFlushTimeout = l;
        return this;
    }

    public StateRetrievalConfigurationBuilder maxNonProgressingLogWrites(int i) {
        this.maxNonProgressingLogWrites = i;
        return this;
    }

    public StateRetrievalConfigurationBuilder numRetries(int i) {
        this.numRetries = i;
        return this;
    }

    public StateRetrievalConfigurationBuilder retryWaitTimeIncreaseFactor(int i) {
        this.retryWaitTimeIncreaseFactor = i;
        return this;
    }

    public StateRetrievalConfigurationBuilder timeout(long l) {
        this.timeout = l;
        return this;
    }

    @Override
    void validate() {
        if (this.fetchInMemoryState != null && this.fetchInMemoryState.booleanValue() && this.getClusteringBuilder().cacheMode().isDistributed()) {
            throw new ConfigurationException("Cache cannot use DISTRIBUTION mode and have fetchInMemoryState set to true on cache named " + this.getBuilder().name + ".  Perhaps you meant to enable rehashing?");
        }
    }

    @Override
    StateRetrievalConfiguration create() {
        Boolean _fetchInMemoryState = this.fetchInMemoryState;
        if (this.getClusteringBuilder().cacheMode().isReplicated() && _fetchInMemoryState == null) {
            log.debug("Cache is replicated but state transfer was not defined, so force enabling it");
            _fetchInMemoryState = true;
        }
        if (_fetchInMemoryState == null) {
            _fetchInMemoryState = false;
        }
        return new StateRetrievalConfiguration(this.alwaysProvideInMemoryState, _fetchInMemoryState, this.fetchInMemoryState, this.initialRetryWaitTime, this.logFlushTimeout, this.maxNonProgressingLogWrites, this.numRetries, this.retryWaitTimeIncreaseFactor, this.timeout);
    }

    public StateRetrievalConfigurationBuilder read(StateRetrievalConfiguration template) {
        this.alwaysProvideInMemoryState = template.alwaysProvideInMemoryState();
        this.fetchInMemoryState = template.originalFetchInMemoryState();
        this.initialRetryWaitTime = template.initialRetryWaitTime();
        this.logFlushTimeout = template.logFlushTimeout();
        this.maxNonProgressingLogWrites = template.maxNonProgressingLogWrites();
        this.numRetries = template.numRetries();
        this.retryWaitTimeIncreaseFactor = template.retryWaitTimeIncreaseFactor();
        this.timeout = template.timeout();
        return this;
    }
}

