/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.versioned;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.entries.versioned.VersionedImmortalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class VersionedImmortalCacheValue
extends ImmortalCacheValue
implements Versioned {
    EntryVersion version;

    public VersionedImmortalCacheValue(Object value, EntryVersion version) {
        super(value);
        this.version = version;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new VersionedImmortalCacheEntry(key, this);
    }

    @Override
    public EntryVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.version = version;
    }

    public static class Externalizer
    extends AbstractExternalizer<VersionedImmortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, VersionedImmortalCacheValue icv) throws IOException {
            output.writeObject(icv.value);
            output.writeObject(icv.version);
        }

        @Override
        public VersionedImmortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            return new VersionedImmortalCacheValue(v, version);
        }

        @Override
        public Integer getId() {
            return 80;
        }

        @Override
        public Set<Class<? extends VersionedImmortalCacheValue>> getTypeClasses() {
            return Util.asSet(VersionedImmortalCacheValue.class);
        }
    }
}

