/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.distribution.ch.VirtualAddress;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractWheelConsistentHash
extends AbstractConsistentHash {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final boolean trace = this.log.isTraceEnabled();
    protected Hash hashFunction;
    protected int numVirtualNodes = 1;
    protected Set<Address> caches;
    protected int[] positionKeys;
    protected Address[] positionValues;

    protected AbstractWheelConsistentHash() {
    }

    public void setHashFunction(Hash h) {
        this.checkCachesUninitialized("hash function");
        this.hashFunction = h;
    }

    private void checkCachesUninitialized(String property) {
        if (this.caches != null) {
            throw new IllegalStateException(String.format("Must configure the %s before adding the caches", property));
        }
    }

    public void setNumVirtualNodes(Integer numVirtualNodes) {
        this.checkCachesUninitialized("number of virtual nodes");
        this.numVirtualNodes = numVirtualNodes;
    }

    @Override
    public void setCaches(Set<Address> newCaches) {
        if (newCaches.size() == 0 || newCaches.contains(null)) {
            throw new IllegalArgumentException("Invalid cache list for consistent hash: " + newCaches);
        }
        if ((long)newCaches.size() * (long)this.numVirtualNodes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many nodes: " + newCaches.size() + " * " + this.numVirtualNodes + " exceeds the available hash space");
        }
        TreeMap<Integer, Address> positions = new TreeMap<Integer, Address>();
        for (Address a : newCaches) {
            this.addNode(positions, a, this.getNormalizedHash(a));
        }
        if (this.isVirtualNodesEnabled()) {
            for (Address a : newCaches) {
                for (int i = 1; i < this.numVirtualNodes; ++i) {
                    VirtualAddress va = new VirtualAddress(a, i);
                    this.addNode(positions, a, this.getNormalizedHash(va));
                }
            }
        }
        this.log.tracef("Positions are: %s", positions);
        this.caches = new LinkedHashSet<Address>(newCaches.size());
        this.positionKeys = new int[positions.size()];
        this.positionValues = new Address[positions.size()];
        int i = 0;
        for (Map.Entry<Integer, Address> position : positions.entrySet()) {
            this.caches.add(position.getValue());
            this.positionKeys[i] = position.getKey();
            this.positionValues[i] = position.getValue();
            ++i;
        }
        this.log.tracef("Consistent hash initialized: %s", this);
    }

    private void addNode(TreeMap<Integer, Address> positions, Address a, int positionIndex) {
        while (positions.containsKey(positionIndex)) {
            if (positionIndex == Integer.MAX_VALUE) {
                positionIndex = 0;
                continue;
            }
            ++positionIndex;
        }
        positions.put(positionIndex, a);
    }

    @Override
    public Set<Address> getCaches() {
        return this.caches;
    }

    protected int getPositionIndex(int normalizedHash) {
        int index = Arrays.binarySearch(this.positionKeys, normalizedHash);
        if (index < 0 && (index = -index - 1) == this.positionKeys.length) {
            index = 0;
        }
        return index;
    }

    protected Iterator<Map.Entry<Integer, Address>> getPositionsIterator(int normalizedHash) {
        final int startIndex = this.getPositionIndex(normalizedHash);
        return new Iterator<Map.Entry<Integer, Address>>(){
            int i;
            {
                this.i = startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Map.Entry<Integer, Address> next() {
                AbstractMap.SimpleImmutableEntry<Integer, Address> value = new AbstractMap.SimpleImmutableEntry<Integer, Address>(AbstractWheelConsistentHash.this.positionKeys[this.i], AbstractWheelConsistentHash.this.positionValues[this.i]);
                ++this.i;
                if (this.i == AbstractWheelConsistentHash.this.positionKeys.length) {
                    this.i = 0;
                }
                if (this.i == startIndex) {
                    this.i = -1;
                }
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The positions map cannot be modified");
            }
        };
    }

    @Override
    public List<Integer> getHashIds(Address a) {
        ArrayList<Integer> hashIds = null;
        boolean vNodesEnabled = this.isVirtualNodesEnabled();
        for (int i = 0; i < this.positionValues.length; ++i) {
            if (!this.positionValues[i].equals(a)) continue;
            if (vNodesEnabled && hashIds == null) {
                hashIds = new ArrayList<Integer>(this.numVirtualNodes);
            }
            if (vNodesEnabled) {
                hashIds.add(this.positionKeys[i]);
                continue;
            }
            return Collections.singletonList(this.positionKeys[i]);
        }
        if (hashIds == null) {
            return Collections.emptyList();
        }
        return hashIds;
    }

    public int getNormalizedHash(Object key) {
        return Util.getNormalizedHash(key, this.hashFunction);
    }

    protected boolean isVirtualNodesEnabled() {
        return this.numVirtualNodes > 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" {");
        for (int i = 0; i < this.positionKeys.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.positionKeys[i]).append(": ").append(this.positionValues[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public static abstract class Externalizer<T extends AbstractWheelConsistentHash>
    extends AbstractExternalizer<T> {
        protected abstract T instance();

        @Override
        public void writeObject(ObjectOutput output, T abstractWheelConsistentHash) throws IOException {
            output.writeInt(((AbstractWheelConsistentHash)abstractWheelConsistentHash).numVirtualNodes);
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).hashFunction);
            output.writeObject(((AbstractWheelConsistentHash)abstractWheelConsistentHash).caches);
        }

        @Override
        public T readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            T instance = this.instance();
            ((AbstractWheelConsistentHash)instance).numVirtualNodes = unmarshaller.readInt();
            Hash hash = (Hash)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)instance).setHashFunction(hash);
            Set caches = (Set)unmarshaller.readObject();
            ((AbstractWheelConsistentHash)instance).setCaches(caches);
            return instance;
        }
    }
}

