/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CommandsFactoryImpl;
import org.infinispan.config.ConfigurationException;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.NonTransactionalInvocationContextContainer;
import org.infinispan.context.TransactionalInvocationContextContainer;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionManagerImpl;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.eviction.PassivationManagerImpl;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheLoaderManagerImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferLockImpl;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={CacheNotifier.class, CommandsFactory.class, CacheLoaderManager.class, InvocationContextContainer.class, PassivationManager.class, BatchContainer.class, TransactionLog.class, EvictionManager.class, TransactionCoordinator.class, RecoveryAdminOperations.class, StateTransferLock.class, ClusteringDependentLogic.class})
public class EmptyConstructorNamedCacheFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (componentType.equals(ClusteringDependentLogic.class)) {
            if (this.configuration.getCacheMode().isReplicated() || !this.configuration.getCacheMode().isClustered() || this.configuration.getCacheMode().isInvalidation()) {
                return componentType.cast(new ClusteringDependentLogic.AllNodesLogic());
            }
            return componentType.cast(new ClusteringDependentLogic.DistributionLogic());
        }
        if (componentType.equals(InvocationContextContainer.class)) {
            Class componentImpl = this.configuration.isTransactionalCache() ? TransactionalInvocationContextContainer.class : NonTransactionalInvocationContextContainer.class;
            return componentType.cast(Util.getInstance(componentImpl));
        }
        if (componentType.equals(CacheNotifier.class)) {
            return (T)new CacheNotifierImpl();
        }
        if (componentType.equals(CommandsFactory.class)) {
            return (T)new CommandsFactoryImpl();
        }
        if (componentType.equals(CacheLoaderManager.class)) {
            return (T)new CacheLoaderManagerImpl();
        }
        if (componentType.equals(PassivationManager.class)) {
            return (T)new PassivationManagerImpl();
        }
        if (componentType.equals(BatchContainer.class)) {
            return (T)new BatchContainer();
        }
        if (componentType.equals(TransactionLog.class)) {
            return (T)new TransactionLog();
        }
        if (componentType.equals(TransactionCoordinator.class)) {
            return (T)new TransactionCoordinator();
        }
        if (componentType.equals(RecoveryAdminOperations.class)) {
            return (T)new RecoveryAdminOperations();
        }
        if (componentType.equals(StateTransferLock.class)) {
            return (T)new StateTransferLockImpl();
        }
        if (componentType.equals(EvictionManager.class)) {
            return (T)new EvictionManagerImpl();
        }
        throw new ConfigurationException("Don't know how to create a " + componentType.getName());
    }
}

