/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.BatchingInterceptor;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.DeadlockDetectingInterceptor;
import org.infinispan.interceptors.DistCacheStoreInterceptor;
import org.infinispan.interceptors.DistTxInterceptor;
import org.infinispan.interceptors.DistributionInterceptor;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.IsMarshallableInterceptor;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.interceptors.NotificationInterceptor;
import org.infinispan.interceptors.PassivationInterceptor;
import org.infinispan.interceptors.ReplicationInterceptor;
import org.infinispan.interceptors.StateTransferLockInterceptor;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.VersionedDistributionInterceptor;
import org.infinispan.interceptors.VersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.VersionedReplicationInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={InterceptorChain.class})
public class InterceptorChainFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(InterceptorChainFactory.class);

    private CommandInterceptor createInterceptor(CommandInterceptor interceptor, Class<? extends CommandInterceptor> interceptorType) {
        CommandInterceptor chainedInterceptor = this.componentRegistry.getComponent(interceptorType);
        if (chainedInterceptor == null) {
            chainedInterceptor = interceptor;
            this.register(interceptorType, chainedInterceptor);
        } else {
            chainedInterceptor.setNext(null);
        }
        return chainedInterceptor;
    }

    private void register(Class<? extends CommandInterceptor> clazz, CommandInterceptor chainedInterceptor) {
        try {
            this.componentRegistry.registerComponent((Object)chainedInterceptor, clazz);
        }
        catch (RuntimeException e) {
            log.warn("Problems creating interceptor " + clazz);
            throw e;
        }
    }

    private boolean isUsingMarshalledValues(Configuration c) {
        return c.isStoreAsBinary() && (c.isStoreKeysAsBinary() || c.isStoreValuesAsBinary());
    }

    public InterceptorChain buildInterceptorChain() {
        boolean needsVersionAwareComponents = this.configuration.isTransactionalCache() && this.configuration.isWriteSkewCheck() && this.configuration.getTransactionLockingMode() == LockingMode.OPTIMISTIC && this.configuration.isEnableVersioning();
        boolean invocationBatching = this.configuration.isInvocationBatchingEnabled();
        CommandInterceptor first = invocationBatching ? this.createInterceptor(new BatchingInterceptor(), BatchingInterceptor.class) : this.createInterceptor(new InvocationContextInterceptor(), InvocationContextInterceptor.class);
        InterceptorChain interceptorChain = new InterceptorChain(first);
        this.componentRegistry.registerComponent((Object)interceptorChain, InterceptorChain.class);
        if (this.isUsingMarshalledValues(this.configuration) || this.configuration.isUseAsyncMarshalling() || this.configuration.isUseReplQueue() || this.hasAsyncStore()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new IsMarshallableInterceptor(), IsMarshallableInterceptor.class), false);
        }
        if (invocationBatching) {
            interceptorChain.appendInterceptor(this.createInterceptor(new InvocationContextInterceptor(), InvocationContextInterceptor.class), false);
        }
        if (this.configuration.isExposeJmxStatistics()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new CacheMgmtInterceptor(), CacheMgmtInterceptor.class), false);
        }
        if (this.configuration.getCacheMode().isDistributed() || this.configuration.getCacheMode().isReplicated()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new StateTransferLockInterceptor(), StateTransferLockInterceptor.class), false);
        }
        if (this.configuration.isTransactionalCache()) {
            if (this.configuration.getCacheMode().isDistributed()) {
                interceptorChain.appendInterceptor(this.createInterceptor(new DistTxInterceptor(), DistTxInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new TxInterceptor(), TxInterceptor.class), false);
            }
        }
        if (this.isUsingMarshalledValues(this.configuration)) {
            interceptorChain.appendInterceptor(this.createInterceptor(new MarshalledValueInterceptor(), MarshalledValueInterceptor.class), false);
        }
        interceptorChain.appendInterceptor(this.createInterceptor(new NotificationInterceptor(), NotificationInterceptor.class), false);
        if (this.configuration.isUseEagerLocking()) {
            this.configuration.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        }
        if (this.configuration.isTransactionalCache()) {
            if (this.configuration.getTransactionLockingMode() == LockingMode.PESSIMISTIC) {
                interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticLockingInterceptor(), PessimisticLockingInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticLockingInterceptor(), OptimisticLockingInterceptor.class), false);
            }
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(new NonTransactionalLockingInterceptor(), NonTransactionalLockingInterceptor.class), false);
        }
        if (needsVersionAwareComponents && this.configuration.getCacheMode().isClustered()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new VersionedEntryWrappingInterceptor(), VersionedEntryWrappingInterceptor.class), false);
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(new EntryWrappingInterceptor(), EntryWrappingInterceptor.class), false);
        }
        if (this.configuration.isUsingCacheLoaders()) {
            if (this.configuration.getCacheLoaderManagerConfig().isPassivation().booleanValue()) {
                interceptorChain.appendInterceptor(this.createInterceptor(new ActivationInterceptor(), ActivationInterceptor.class), false);
                interceptorChain.appendInterceptor(this.createInterceptor(new PassivationInterceptor(), PassivationInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new CacheLoaderInterceptor(), CacheLoaderInterceptor.class), false);
                switch (this.configuration.getCacheMode()) {
                    case DIST_SYNC: 
                    case DIST_ASYNC: {
                        interceptorChain.appendInterceptor(this.createInterceptor(new DistCacheStoreInterceptor(), DistCacheStoreInterceptor.class), false);
                        break;
                    }
                    default: {
                        interceptorChain.appendInterceptor(this.createInterceptor(new CacheStoreInterceptor(), CacheStoreInterceptor.class), false);
                    }
                }
            }
        }
        if (this.configuration.isEnableDeadlockDetection()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new DeadlockDetectingInterceptor(), DeadlockDetectingInterceptor.class), false);
        }
        switch (this.configuration.getCacheMode()) {
            case REPL_SYNC: {
                if (needsVersionAwareComponents) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new VersionedReplicationInterceptor(), VersionedReplicationInterceptor.class), false);
                    break;
                }
            }
            case REPL_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(new ReplicationInterceptor(), ReplicationInterceptor.class), false);
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(new InvalidationInterceptor(), InvalidationInterceptor.class), false);
                break;
            }
            case DIST_SYNC: {
                if (needsVersionAwareComponents) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new VersionedDistributionInterceptor(), VersionedDistributionInterceptor.class), false);
                    break;
                }
            }
            case DIST_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(new DistributionInterceptor(), DistributionInterceptor.class), false);
                break;
            }
        }
        CommandInterceptor callInterceptor = this.createInterceptor(new CallInterceptor(), CallInterceptor.class);
        interceptorChain.appendInterceptor(callInterceptor, false);
        if (log.isTraceEnabled()) {
            log.trace("Finished building default interceptor chain.");
        }
        this.buildCustomInterceptors(interceptorChain, this.configuration.getCustomInterceptors());
        return interceptorChain;
    }

    private Class<? extends CommandInterceptor> getCustomInterceptorType(CustomInterceptorConfig cfg) {
        if (cfg.getInterceptor() != null) {
            return cfg.getInterceptor().getClass();
        }
        return Util.loadClass(cfg.getClassName(), this.configuration.getClassLoader());
    }

    private CommandInterceptor getOrCreateCustomInterceptor(CustomInterceptorConfig cfg) {
        CommandInterceptor result = cfg.getInterceptor();
        if (result == null) {
            result = (CommandInterceptor)Util.getInstance(cfg.getClassName(), this.configuration.getClassLoader());
        }
        this.register(result.getClass(), result);
        return result;
    }

    private void buildCustomInterceptors(InterceptorChain interceptorChain, List<CustomInterceptorConfig> customInterceptors) {
        for (CustomInterceptorConfig config : customInterceptors) {
            List<CommandInterceptor> withClassName;
            if (interceptorChain.containsInterceptorType(this.getCustomInterceptorType(config))) continue;
            CommandInterceptor customInterceptor = this.getOrCreateCustomInterceptor(config);
            if (config.isFirst()) {
                interceptorChain.addInterceptor(customInterceptor, 0);
                continue;
            }
            if (config.isLast()) {
                interceptorChain.appendInterceptor(customInterceptor, true);
                continue;
            }
            if (config.getIndex() >= 0) {
                interceptorChain.addInterceptor(customInterceptor, config.getIndex());
                continue;
            }
            if (config.getAfter() != null) {
                withClassName = interceptorChain.getInterceptorsWithClassName(config.getAfter());
                if (withClassName.isEmpty()) {
                    throw new ConfigurationException("Cannot add after class: " + config.getAfter() + " as no such interceptor exists in the default chain");
                }
                interceptorChain.addInterceptorAfter(customInterceptor, withClassName.get(0).getClass());
                continue;
            }
            if (config.getBefore() == null) continue;
            withClassName = interceptorChain.getInterceptorsWithClassName(config.getBefore());
            if (withClassName.isEmpty()) {
                throw new ConfigurationException("Cannot add before class: " + config.getAfter() + " as no such interceptor exists in the default chain");
            }
            interceptorChain.addInterceptorBefore(customInterceptor, withClassName.get(0).getClass());
        }
    }

    private boolean hasAsyncStore() {
        List<CacheLoaderConfig> loaderConfigs = this.configuration.getCacheLoaderManagerConfig().getCacheLoaderConfigs();
        for (CacheLoaderConfig loaderConfig : loaderConfigs) {
            CacheStoreConfig storeConfig;
            if (!(loaderConfig instanceof CacheStoreConfig) || !(storeConfig = (CacheStoreConfig)loaderConfig).getAsyncStoreConfig().isEnabled().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        try {
            return componentType.cast(this.buildInterceptorChain());
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build interceptor chain", e);
        }
    }

    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

