/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ModuleMetadataFileFinder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentMetadataRepo {
    static final Map<String, ComponentMetadata> COMPONENT_METADATA_MAP = new HashMap<String, ComponentMetadata>(128);
    static final Map<String, String> FACTORIES = new HashMap<String, String>(16);
    private static final ComponentMetadata DEPENDENCY_FREE_COMPONENT = new ComponentMetadata();
    private static final Log log = LogFactory.getLog(ComponentMetadataRepo.class);

    public static synchronized void readMetadata(URL metadataFile) throws IOException, ClassNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(metadataFile.openStream());
        ObjectInputStream ois = new ObjectInputStream(bis);
        Map comp = (Map)ois.readObject();
        Map fact = (Map)ois.readObject();
        COMPONENT_METADATA_MAP.putAll(comp);
        FACTORIES.putAll(fact);
    }

    public static ComponentMetadata findComponentMetadata(Class<?> componentType) {
        ComponentMetadata md = null;
        while (md == null) {
            String componentName = componentType.getName();
            md = COMPONENT_METADATA_MAP.get(componentName);
            if (md != null) continue;
            if (!componentType.equals(Object.class) && !componentType.isInterface()) {
                componentType = componentType.getSuperclass();
                continue;
            }
            md = DEPENDENCY_FREE_COMPONENT;
        }
        return md;
    }

    public static ComponentMetadata findComponentMetadata(String componentName) {
        return COMPONENT_METADATA_MAP.get(componentName);
    }

    public static String findFactoryForComponent(Class<?> componentType) {
        return FACTORIES.get(componentType.getName());
    }

    public static void initialize(Iterable<ModuleMetadataFileFinder> moduleMetadataFiles, ClassLoader cl) {
        try {
            ComponentMetadataRepo.readMetadata(cl.getResource("infinispan-core-component-metadata.dat"));
        }
        catch (Exception e) {
            throw new CacheException("Unable to load component metadata!", e);
        }
        for (ModuleMetadataFileFinder finder : moduleMetadataFiles) {
            try {
                ComponentMetadataRepo.readMetadata(cl.getResource(finder.getMetadataFilename()));
            }
            catch (Exception e) {
                throw new CacheException("Unable to load component metadata in file " + finder.getMetadataFilename(), e);
            }
        }
    }
}

