/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.util.ReflectionUtil;

public class JmxAttributeMetadata
implements Serializable {
    private String name;
    private String description;
    private boolean writable;
    private boolean useSetter;
    private String type;
    private boolean is;

    private JmxAttributeMetadata(ManagedAttribute annotation) {
        this.description = annotation.description();
        this.writable = annotation.writable();
    }

    public JmxAttributeMetadata(Field field) {
        this(field.getAnnotation(ManagedAttribute.class));
        this.name = field.getName();
        this.type = field.getType().toString();
    }

    public JmxAttributeMetadata(Method method) {
        this(method.getAnnotation(ManagedAttribute.class));
        String methodName = method.getName();
        this.name = ReflectionUtil.extractFieldName(methodName);
        this.is = methodName.startsWith("is");
        if (methodName.startsWith("set")) {
            this.useSetter = true;
            this.type = method.getParameterTypes()[0].getName();
        } else if (methodName.startsWith("get") || this.is) {
            Class<?> clazz = method.getDeclaringClass();
            Method setterMethod = ReflectionUtil.findSetterForField(clazz, this.name);
            this.type = method.getReturnType().getName();
            this.useSetter = setterMethod != null || !this.writable;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isUseSetter() {
        return this.useSetter;
    }

    public String getType() {
        return this.type;
    }

    public boolean isIs() {
        return this.is;
    }

    public String toString() {
        return "JmxAttributeMetadata{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", writable=" + this.writable + ", type='" + this.type + '\'' + ", is=" + this.is + '}';
    }
}

