/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.TimeUnit;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.StateTransferInProgressException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockInterceptor
extends CommandInterceptor {
    StateTransferLock stateTransferLock;
    private long rpcTimeout;
    private static final Log log = LogFactory.getLog(StateTransferLockInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(StateTransferLock stateTransferLock, Configuration configuration) {
        this.stateTransferLock = stateTransferLock;
        this.rpcTimeout = configuration.getCacheMode().isSynchronous() ? configuration.getSyncReplTimeout() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, Long.MAX_VALUE);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            return this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            this.signalStateTransferInProgress();
        }
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        finally {
            this.stateTransferLock.releaseForCommand(ctx, command);
        }
    }

    private Object signalStateTransferInProgress() {
        int viewId = this.stateTransferLock.getBlockingCacheViewId();
        throw new StateTransferInProgressException(viewId, "Timed out waiting for the state transfer lock, state transfer in progress for view " + viewId);
    }

    private Object handleWithRetries(InvocationContext ctx, VisitableCommand command, long timeoutMillis) throws Throwable {
        long endNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        while (true) {
            int newCacheViewId = -1;
            try {
                return this.invokeNextInterceptor(ctx, command);
            }
            catch (StateTransferInProgressException e) {
                newCacheViewId = e.getNewCacheViewId();
            }
            catch (SuspectException e) {
                ++newCacheViewId;
            }
            if (endNanos < System.nanoTime()) {
                throw new TimeoutException("Timed out waiting for the state transfer to end");
            }
            this.stateTransferLock.waitForStateTransferToEnd(ctx, command, newCacheViewId);
        }
    }
}

