/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.DistributionInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedDistributionInterceptor
extends DistributionInterceptor {
    private static final Log log = LogFactory.getLog(VersionedDistributionInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected PrepareCommand buildPrepareCommandForResend(TxInvocationContext ctx, CommitCommand commit) {
        VersionedPrepareCommand command = this.cf.buildVersionedPrepareCommand(commit.getGlobalTransaction(), ctx.getModifications(), true);
        EntryVersionsMap vs = new EntryVersionsMap();
        for (CacheEntry ce : ctx.getLookedUpEntries().values()) {
            vs.put(ce.getKey(), (IncrementableEntryVersion)ce.getVersion());
        }
        command.setVersionsSeen(vs);
        return command;
    }

    @Override
    protected void prepareOnAffectedNodes(TxInvocationContext ctx, PrepareCommand command, Collection<Address> recipients, boolean ignored) {
        EntryVersionsMap vs = new EntryVersionsMap();
        for (WriteCommand wc : command.getModifications()) {
            for (Object k : wc.getAffectedKeys()) {
                vs.put(k, (IncrementableEntryVersion)ctx.lookupEntry(k).getVersion());
            }
        }
        ((VersionedPrepareCommand)command).setVersionsSeen(vs);
        Map<Address, Response> resps = this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, true, true);
        CacheTransaction ct = ctx.getCacheTransaction();
        for (Response r : resps.values()) {
            SuccessfulResponse sr;
            EntryVersionsMap uv;
            if (r == null || !r.isSuccessful() || (uv = (EntryVersionsMap)(sr = (SuccessfulResponse)r).getResponseValue()) == null) continue;
            ct.setUpdatedEntryVersions(uv.merge(ct.getUpdatedEntryVersions()));
        }
    }
}

