/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.cacheviews.CacheView;
import org.infinispan.cacheviews.CacheViewListener;
import org.infinispan.cacheviews.CacheViewsManager;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.BaseStateTransferTask;
import org.infinispan.statetransfer.StateTransferCancelledException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseStateTransferManagerImpl
implements StateTransferManager,
CacheViewListener {
    private static final Log log = LogFactory.getLog(BaseStateTransferManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    protected CacheLoaderManager cacheLoaderManager;
    protected Configuration configuration;
    protected RpcManager rpcManager;
    private CacheManagerNotifier notifier;
    protected CommandsFactory cf;
    protected DataContainer dataContainer;
    protected InterceptorChain interceptorChain;
    protected InvocationContextContainer icc;
    protected CacheNotifier cacheNotifier;
    private CacheViewsManager cacheViewsManager;
    protected StateTransferLock stateTransferLock;
    protected volatile ConsistentHash chOld;
    private volatile CacheView oldView;
    protected volatile ConsistentHash chNew;
    private volatile CacheView newView;
    private final CountDownLatch joinStartedLatch = new CountDownLatch(1);
    private final CountDownLatch joinCompletedLatch = new CountDownLatch(1);
    private final ReclosableLatch stateTransferInProgressLatch = new ReclosableLatch(false);
    private volatile BaseStateTransferTask stateTransferTask;
    private CommandBuilder commandBuilder;

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CacheManagerNotifier notifier, CommandsFactory cf, DataContainer dataContainer, InterceptorChain interceptorChain, InvocationContextContainer icc, CacheLoaderManager cacheLoaderManager, CacheNotifier cacheNotifier, StateTransferLock stateTransferLock, CacheViewsManager cacheViewsManager) {
        this.cacheLoaderManager = cacheLoaderManager;
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.notifier = notifier;
        this.cf = cf;
        this.stateTransferLock = stateTransferLock;
        this.dataContainer = dataContainer;
        this.interceptorChain = interceptorChain;
        this.icc = icc;
        this.cacheNotifier = cacheNotifier;
        this.cacheViewsManager = cacheViewsManager;
    }

    @Start(priority=60)
    private void start() throws Exception {
        this.commandBuilder = this.configuration.isTransactionalCache() && this.configuration.isEnableVersioning() && this.configuration.isWriteSkewCheck() && this.configuration.getTransactionLockingMode() == LockingMode.OPTIMISTIC && this.configuration.getCacheMode().isClustered() ? new CommandBuilder(){

            @Override
            public PutKeyValueCommand buildPut(InvocationContext ctx, CacheEntry e) {
                EntryVersion version = e.getVersion();
                return BaseStateTransferManagerImpl.this.cf.buildVersionedPutKeyValueCommand(e.getKey(), e.getValue(), e.getLifespan(), e.getMaxIdle(), e.getVersion(), ctx.getFlags());
            }
        } : new CommandBuilder(){

            @Override
            public PutKeyValueCommand buildPut(InvocationContext ctx, CacheEntry e) {
                return BaseStateTransferManagerImpl.this.cf.buildPutKeyValueCommand(e.getKey(), e.getValue(), e.getLifespan(), e.getMaxIdle(), ctx.getFlags());
            }
        };
        if (trace) {
            log.tracef("Starting state transfer manager on " + this.getAddress(), new Object[0]);
        }
        this.cacheViewsManager.join(this.configuration.getName(), this);
    }

    protected abstract ConsistentHash createConsistentHash(List<Address> var1);

    @Override
    @Start(priority=1000)
    public void waitForJoinToComplete() throws InterruptedException {
        this.joinCompletedLatch.await(this.configuration.getRehashWaitTime(), TimeUnit.MILLISECONDS);
    }

    @Stop(priority=20)
    public void stop() {
        this.chOld = null;
        this.chNew = null;
        BaseStateTransferTask tempTask = this.stateTransferTask;
        if (tempTask != null) {
            tempTask.cancelStateTransfer(true, false);
            this.stateTransferTask = null;
        }
        this.cacheViewsManager.leave(this.configuration.getName());
        this.joinStartedLatch.countDown();
        this.joinCompletedLatch.countDown();
        this.stateTransferInProgressLatch.open();
    }

    protected Address getAddress() {
        return this.rpcManager.getAddress();
    }

    @Override
    public boolean hasJoinStarted() {
        return this.isLatchOpen(this.joinStartedLatch);
    }

    @Override
    public void waitForJoinToStart() throws InterruptedException {
        this.joinStartedLatch.await(this.configuration.getRehashWaitTime(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isJoinComplete() {
        return this.isLatchOpen(this.joinCompletedLatch);
    }

    @Override
    public boolean isStateTransferInProgress() {
        return !this.isLatchOpen(this.stateTransferInProgressLatch);
    }

    public void waitForStateTransferToStart(int viewId) throws InterruptedException {
        while (this.newView == null || this.newView.getViewId() < viewId) {
            Thread.sleep(1L);
        }
    }

    @Override
    public void waitForStateTransferToComplete() throws InterruptedException {
        this.stateTransferInProgressLatch.await(this.configuration.getRehashWaitTime(), TimeUnit.MILLISECONDS);
    }

    private boolean isLatchOpen(CountDownLatch latch) {
        try {
            return latch.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    private boolean isLatchOpen(ReclosableLatch latch) {
        try {
            return latch.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    @Override
    public void applyState(Collection<InternalCacheEntry> state, Address sender, int viewId) throws InterruptedException {
        this.waitForStateTransferToStart(viewId);
        if (this.newView == this.oldView) {
            log.remoteStateRejected(sender, viewId, this.oldView.getViewId());
            return;
        }
        if (viewId != this.newView.getViewId()) {
            log.debugf("Rejecting state pushed by node %s for rehash %d (last view id we know is %d)", sender, viewId, this.newView.getViewId());
            return;
        }
        log.debugf("Applying new state from %s: received %d keys", sender, state.size());
        if (trace) {
            log.tracef("Received keys: %s", this.keys(state));
        }
        for (InternalCacheEntry e : state) {
            InvocationContext ctx = this.icc.createInvocationContext(false, 1);
            ctx.setFlags(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_SHARED_CACHE_STORE, Flag.SKIP_LOCKING, Flag.SKIP_OWNERSHIP_CHECK);
            try {
                PutKeyValueCommand put = this.commandBuilder.buildPut(ctx, e);
                this.interceptorChain.invoke(ctx, put);
            }
            catch (Exception ee) {
                log.problemApplyingStateForKey(ee.getMessage(), e.getKey());
            }
        }
        if (trace) {
            log.tracef("After applying state data container has %d keys", this.dataContainer.size());
        }
    }

    private Collection<Object> keys(Collection<InternalCacheEntry> state) {
        ArrayList<Object> result = new ArrayList<Object>(state.size());
        for (InternalCacheEntry e : state) {
            result.add(e.getKey());
        }
        return result;
    }

    public boolean startStateTransfer(int viewId, Collection<Address> members, boolean initialView) throws TimeoutException, InterruptedException, StateTransferCancelledException {
        if (this.newView == null || viewId != this.newView.getViewId()) {
            log.debugf("Cannot start state transfer for view %d, we should be starting state transfer for view %s", viewId, this.newView);
            return false;
        }
        this.stateTransferInProgressLatch.close();
        return true;
    }

    public void endStateTransfer() {
        this.oldView = this.newView;
        this.chOld = this.chNew;
        this.stateTransferInProgressLatch.open();
        this.joinCompletedLatch.countDown();
    }

    public abstract CacheStore getCacheStoreForStateTransfer();

    public void pushStateToNode(NotifyingNotifiableFuture<Object> stateTransferFuture, int viewId, Collection<Address> targets, Collection<InternalCacheEntry> state) throws StateTransferCancelledException {
        log.debugf("Pushing to nodes %s %d keys", targets, state.size());
        log.tracef("Pushing to nodes %s keys: %s", targets, this.keys(state));
        StateTransferControlCommand cmd = this.cf.buildStateTransferCommand(StateTransferControlCommand.Type.APPLY_STATE, this.getAddress(), viewId, state);
        this.rpcManager.invokeRemotelyInFuture(targets, cmd, false, stateTransferFuture, this.configuration.getRehashRpcTimeout());
    }

    public boolean isLastViewId(int viewId) {
        return viewId == this.newView.getViewId();
    }

    @Override
    public void prepareView(CacheView pendingView, CacheView committedView) throws Exception {
        log.tracef("Received new cache view: %s %s", this.configuration.getName(), pendingView);
        this.joinStartedLatch.countDown();
        this.newView = pendingView;
        this.chNew = this.createConsistentHash(pendingView.getMembers());
        this.stateTransferTask = this.createStateTransferTask(pendingView.getViewId(), pendingView.getMembers(), this.chOld == null);
        this.stateTransferTask.performStateTransfer();
    }

    @Override
    public void commitView(int viewId) {
        BaseStateTransferTask tempTask = this.stateTransferTask;
        if (tempTask == null) {
            if (viewId == this.oldView.getViewId()) {
                log.tracef("Ignoring commit for cache view %d as we have already committed it", viewId);
                return;
            }
            throw new IllegalArgumentException(String.format("Cannot commit view %d, we are at view %d", viewId, this.oldView.getViewId()));
        }
        tempTask.commitStateTransfer();
        this.stateTransferTask = null;
        this.endStateTransfer();
    }

    @Override
    public void rollbackView(int committedViewId) {
        BaseStateTransferTask tempTask = this.stateTransferTask;
        if (tempTask == null) {
            if (committedViewId == this.oldView.getViewId()) {
                log.tracef("Ignoring rollback for cache view %d as we don't have a state transfer in progress", committedViewId);
                return;
            }
            throw new IllegalArgumentException(String.format("Cannot rollback to view %d, we are at view %d", committedViewId, this.oldView.getViewId()));
        }
        tempTask.cancelStateTransfer(true, false);
        this.stateTransferTask = null;
        this.newView = this.oldView;
        this.chNew = this.chOld;
        this.stateTransferInProgressLatch.open();
        this.joinCompletedLatch.countDown();
    }

    @Override
    public void waitForPrepare() {
        this.stateTransferLock.blockNewTransactionsAsync();
    }

    protected abstract BaseStateTransferTask createStateTransferTask(int var1, List<Address> var2, boolean var3);

    private static interface CommandBuilder {
        public PutKeyValueCommand buildPut(InvocationContext var1, CacheEntry var2);
    }
}

