/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.BaseStateTransferManagerImpl;
import org.infinispan.statetransfer.StateTransferCancelledException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseStateTransferTask {
    private static final Log log = LogFactory.getLog(BaseStateTransferTask.class);
    protected final Configuration configuration;
    protected final BaseStateTransferManagerImpl stateTransferManager;
    protected final StateTransferLock stateTransferLock;
    protected final CacheNotifier cacheNotifier;
    protected final int newViewId;
    protected final DataContainer dataContainer;
    protected final Address self;
    protected final boolean trace = log.isTraceEnabled();
    protected final Collection<Address> members;
    protected final ConsistentHash chOld;
    protected final ConsistentHash chNew;
    protected final boolean initialView;
    private long stateTransferStartMillis;
    private final AggregatingNotifyingFutureBuilder statePushFuture;
    private boolean running;
    private boolean cancelled;
    private final Object lock = new Object();
    protected int stateTransferChunkSize = 10000;

    public BaseStateTransferTask(BaseStateTransferManagerImpl stateTransferManager, RpcManager rpcManager, StateTransferLock stateTransferLock, CacheNotifier cacheNotifier, Configuration configuration, DataContainer dataContainer, Collection<Address> members, int newViewId, ConsistentHash chNew, ConsistentHash chOld, boolean initialView) {
        this.stateTransferLock = stateTransferLock;
        this.initialView = initialView;
        this.stateTransferManager = stateTransferManager;
        this.cacheNotifier = cacheNotifier;
        this.self = rpcManager.getAddress();
        this.configuration = configuration;
        this.members = members;
        this.newViewId = newViewId;
        this.dataContainer = dataContainer;
        this.chNew = chNew;
        this.chOld = chOld;
        this.statePushFuture = new AggregatingNotifyingFutureBuilder(null, members.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performStateTransfer() throws Exception {
        this.stateTransferStartMillis = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.running = true;
        }
        try {
            this.doPerformStateTransfer();
        }
        finally {
            object = this.lock;
            synchronized (object) {
                this.running = false;
                this.lock.notifyAll();
            }
        }
    }

    public abstract void doPerformStateTransfer() throws Exception;

    public void commitStateTransfer() {
        if (this.running) {
            throw new IllegalStateException("State transfer has not finished, cannot commit");
        }
        try {
            this.stateTransferLock.unblockNewTransactions(this.newViewId);
        }
        catch (Exception e) {
            log.errorUnblockingTransactions(e);
        }
        log.debugf("Node %s completed state transfer for view %d in %s!", this.self, this.newViewId, Util.prettyPrintTime(System.currentTimeMillis() - this.stateTransferStartMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelStateTransfer(boolean sync, boolean releaseStateTransferLock) {
        Object object = this.lock;
        synchronized (object) {
            this.cancelled = true;
            if (sync) {
                while (this.running) {
                    try {
                        this.lock.wait(this.configuration.getCacheStopTimeout());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }
        if (releaseStateTransferLock) {
            try {
                this.stateTransferLock.unblockNewTransactions(this.newViewId);
            }
            catch (Exception e) {
                log.errorUnblockingTransactions(e);
            }
        }
        log.debugf("Node %s cancelled state transfer for view %d after %s!", this.self, this.newViewId, Util.prettyPrintTime(System.currentTimeMillis() - this.stateTransferStartMillis));
    }

    protected void finishPushingState() throws InterruptedException, ExecutionException, TimeoutException {
        this.statePushFuture.get(this.configuration.getRehashRpcTimeout(), TimeUnit.MILLISECONDS);
        log.debugf("Node finished pushing data for cache views %d.", this.newViewId);
    }

    protected void pushPartialState(Collection<Address> targets, Collection<InternalCacheEntry> state) throws StateTransferCancelledException {
        this.checkIfCancelled();
        this.stateTransferManager.pushStateToNode(this.statePushFuture, this.newViewId, targets, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIfCancelled() throws StateTransferCancelledException {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                throw new StateTransferCancelledException();
            }
        }
    }
}

