/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GenericTransactionManagerLookup
implements TransactionManagerLookup {
    private static final Log log = LogFactory.getLog(GenericTransactionManagerLookup.class);
    private boolean lookupDone = false;
    private boolean lookupFailed = false;
    private TransactionManager tm = null;
    private static String[][] knownJNDIManagers = new String[][]{{"java:jboss/TransactionManager", "JBoss AS 7"}, {"java:/TransactionManager", "JBoss AS 4 ~ 6, JRun4"}, {"java:comp/TransactionManager", "Resin 3.x"}, {"java:appserver/TransactionManager", "Sun Glassfish"}, {"java:pm/TransactionManager", "Borland, Sun"}, {"javax.transaction.TransactionManager", "BEA WebLogic"}, {"java:comp/UserTransaction", "Resin, Orion, JOnAS (JOTM)"}};
    private static final String WS_FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    private Configuration configuration;

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public TransactionManager getTransactionManager() {
        if (!this.lookupDone) {
            this.doLookups(this.configuration.getClassLoader());
        }
        if (this.tm != null) {
            return this.tm;
        }
        if (this.lookupFailed) {
            this.tm = DummyTransactionManager.getInstance();
            log.fallingBackToDummyTm();
        }
        return this.tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLookups(ClassLoader cl) {
        Class clazz;
        if (this.lookupFailed) {
            return;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.failedToCreateInitialCtx(e);
            this.lookupFailed = true;
            Util.close(ctx);
            return;
        }
        try {
            for (String[] knownJNDIManager : knownJNDIManagers) {
                Object jndiObject;
                try {
                    log.debugf("Trying to lookup TransactionManager for %s", knownJNDIManager[1]);
                    jndiObject = ctx.lookup(knownJNDIManager[0]);
                }
                catch (NamingException e) {
                    log.debugf("Failed to perform a lookup for [%s (%s)]", knownJNDIManager[0], knownJNDIManager[1]);
                    continue;
                }
                if (!(jndiObject instanceof TransactionManager)) continue;
                this.tm = (TransactionManager)jndiObject;
                log.debugf("Found TransactionManager for %s", knownJNDIManager[1]);
                return;
            }
        }
        finally {
            Util.close(ctx);
        }
        try {
            log.debugf("Trying WebSphere 5.1: %s", WS_FACTORY_CLASS_5_1);
            clazz = Util.loadClassStrict(WS_FACTORY_CLASS_5_1, cl);
            log.debugf("Found WebSphere 5.1: %s", WS_FACTORY_CLASS_5_1);
        }
        catch (ClassNotFoundException ex) {
            try {
                log.debugf("Trying WebSphere 5.0: %s", WS_FACTORY_CLASS_5_0);
                clazz = Util.loadClassStrict(WS_FACTORY_CLASS_5_0, cl);
                log.debugf("Found WebSphere 5.0: %s", WS_FACTORY_CLASS_5_0);
            }
            catch (ClassNotFoundException ex2) {
                try {
                    log.debugf("Trying WebSphere 4: %s", WS_FACTORY_CLASS_4);
                    clazz = Util.loadClassStrict(WS_FACTORY_CLASS_4, cl);
                    log.debugf("Found WebSphere 4: %s", WS_FACTORY_CLASS_4);
                }
                catch (ClassNotFoundException ex3) {
                    log.debug("Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4");
                    this.lookupFailed = true;
                    return;
                }
            }
        }
        try {
            Class<?>[] signature = null;
            Object[] args = null;
            Method method = clazz.getMethod("getTransactionManager", signature);
            this.tm = (TransactionManager)method.invoke(null, args);
        }
        catch (Exception ex) {
            log.unableToInvokeWebsphereStaticGetTmMethod(ex, clazz.getName());
        }
    }
}

