/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractCustomInterceptorsConfigurationChildBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.interceptors.base.CommandInterceptor;

public class InterceptorConfigurationBuilder
extends AbstractCustomInterceptorsConfigurationChildBuilder<InterceptorConfiguration> {
    private Class<? extends CommandInterceptor> after;
    private Class<? extends CommandInterceptor> before;
    private CommandInterceptor interceptor;
    private int index = -1;
    private InterceptorConfiguration.Position position = null;

    InterceptorConfigurationBuilder(CustomInterceptorsConfigurationBuilder builder) {
        super(builder);
    }

    public InterceptorConfigurationBuilder after(Class<? extends CommandInterceptor> after) {
        this.after = after;
        return this;
    }

    public InterceptorConfigurationBuilder before(Class<? extends CommandInterceptor> before) {
        this.before = before;
        return this;
    }

    public InterceptorConfigurationBuilder interceptor(CommandInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public InterceptorConfigurationBuilder index(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Index cannot be negative");
        }
        this.index = i;
        return this;
    }

    public InterceptorConfigurationBuilder position(InterceptorConfiguration.Position p) {
        this.position = p;
        return this;
    }

    @Override
    void validate() {
        int positions = 0;
        if (this.before != null) {
            ++positions;
        }
        if (this.after != null) {
            ++positions;
        }
        if (this.position != null) {
            ++positions;
        }
        if (this.index > -1) {
            ++positions;
        }
        switch (positions) {
            case 0: {
                this.position = InterceptorConfiguration.Position.OTHER_THAN_FIRST_OR_LAST;
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new ConfigurationException("You can only specify the position of a custom interceptor once.");
            }
        }
    }

    @Override
    InterceptorConfiguration create() {
        return new InterceptorConfiguration(this.after, this.before, this.interceptor, this.index, this.position);
    }

    public InterceptorConfigurationBuilder read(InterceptorConfiguration template) {
        this.after = template.after();
        this.before = template.before();
        this.index = template.index();
        this.interceptor = template.interceptor();
        this.position = template.position();
        return this;
    }
}

