/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.AbstractLoaderConfiguration;
import org.infinispan.configuration.cache.AbstractLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfiguration;

public class LoadersConfigurationBuilder
extends AbstractConfigurationChildBuilder<LoadersConfiguration> {
    private boolean passivation = false;
    private boolean preload = false;
    private boolean shared = false;
    private List<AbstractLoaderConfigurationBuilder<?>> cacheLoaders = new ArrayList(2);

    protected LoadersConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public LoadersConfigurationBuilder passivation(boolean b) {
        this.passivation = b;
        return this;
    }

    boolean passivation() {
        return this.passivation;
    }

    public LoadersConfigurationBuilder preload(boolean b) {
        this.preload = b;
        return this;
    }

    public LoadersConfigurationBuilder shared(boolean b) {
        this.shared = b;
        return this;
    }

    boolean shared() {
        return this.shared;
    }

    public LoaderConfigurationBuilder addCacheLoader() {
        LoaderConfigurationBuilder builder = new LoaderConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    public FileCacheStoreConfigurationBuilder addFileCacheStore() {
        FileCacheStoreConfigurationBuilder builder = new FileCacheStoreConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    List<AbstractLoaderConfigurationBuilder<?>> cacheLoaders() {
        return this.cacheLoaders;
    }

    @Override
    void validate() {
        for (AbstractLoaderConfigurationBuilder<?> b : this.cacheLoaders) {
            b.validate();
        }
    }

    @Override
    LoadersConfiguration create() {
        LinkedList<AbstractLoaderConfiguration> loaders = new LinkedList<AbstractLoaderConfiguration>();
        for (AbstractLoaderConfigurationBuilder<?> loader : this.cacheLoaders) {
            loaders.add((AbstractLoaderConfiguration)loader.create());
        }
        return new LoadersConfiguration(this.passivation, this.preload, this.shared, loaders);
    }

    public LoadersConfigurationBuilder read(LoadersConfiguration template) {
        for (AbstractLoaderConfiguration c : template.cacheLoaders()) {
            if (c instanceof LoaderConfiguration) {
                this.addCacheLoader().read((LoaderConfiguration)c);
                continue;
            }
            if (!(c instanceof FileCacheStoreConfiguration)) continue;
            this.addFileCacheStore().read((FileCacheStoreConfiguration)c);
        }
        this.passivation = template.passivation();
        this.preload = template.preload();
        this.shared = template.shared();
        return this;
    }
}

