/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.ModuleProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class GlobalComponentRegistry
extends AbstractComponentRegistry {
    private static final Log log = LogFactory.getLog(GlobalComponentRegistry.class);
    private static boolean versionLogged = false;
    private Thread shutdownHook;
    private boolean invokedFromShutdownHook;
    private final GlobalConfiguration globalConfiguration;
    private final Set<String> createdCaches;
    private final ModuleProperties moduleProperties = new ModuleProperties();
    final List<ModuleLifecycle> moduleLifecycles;
    Map<String, ComponentRegistry> namedComponents = new HashMap<String, ComponentRegistry>(4);

    public GlobalComponentRegistry(GlobalConfiguration configuration, EmbeddedCacheManager cacheManager, Set<String> createdCaches) {
        super(configuration.getClassLoader());
        this.moduleLifecycles = ModuleProperties.resolveModuleLifecycles(this.defaultClassLoader);
        ComponentMetadataRepo.initialize(ModuleProperties.getModuleMetadataFiles(this.defaultClassLoader), this.defaultClassLoader);
        try {
            this.globalConfiguration = configuration;
            this.registerComponent((Object)this, GlobalComponentRegistry.class);
            this.registerComponent((Object)cacheManager, EmbeddedCacheManager.class);
            this.registerComponent((Object)configuration, GlobalConfiguration.class);
            this.registerComponent((Object)new CacheManagerJmxRegistration(), CacheManagerJmxRegistration.class);
            this.registerComponent((Object)new CacheManagerNotifierImpl(), CacheManagerNotifier.class);
            this.moduleProperties.loadModuleCommandHandlers(configuration.getClassLoader());
            Map<Byte, ModuleCommandFactory> factories = this.moduleProperties.moduleCommandFactories();
            if (factories != null && !factories.isEmpty()) {
                this.registerNonVolatileComponent(factories, "org.infinispan.modules.command.factories");
            } else {
                this.registerNonVolatileComponent(Collections.emptyMap(), "org.infinispan.modules.command.factories");
            }
            this.createdCaches = createdCaches;
            this.getOrCreateComponent(Transport.class);
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a GlobalComponentRegistry!", e);
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected void removeShutdownHook() {
        if (!this.invokedFromShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    @Override
    protected void addShutdownHook() {
        boolean registerShutdownHook;
        ArrayList<MBeanServer> al = MBeanServerFactory.findMBeanServer(null);
        boolean bl = registerShutdownHook = this.globalConfiguration.getShutdownHookBehavior() == GlobalConfiguration.ShutdownHookBehavior.DEFAULT && al.isEmpty() || this.globalConfiguration.getShutdownHookBehavior() == GlobalConfiguration.ShutdownHookBehavior.REGISTER;
        if (registerShutdownHook) {
            log.tracef("Registering a shutdown hook.  Configured behavior = %s", (Object)this.globalConfiguration.getShutdownHookBehavior());
            this.shutdownHook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        GlobalComponentRegistry.this.invokedFromShutdownHook = true;
                        GlobalComponentRegistry.this.stop();
                    }
                    finally {
                        GlobalComponentRegistry.this.invokedFromShutdownHook = false;
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            log.tracef("Not registering a shutdown hook.  Configured behavior = %s", (Object)this.globalConfiguration.getShutdownHookBehavior());
        }
    }

    public final ComponentRegistry getNamedComponentRegistry(String name) {
        return this.namedComponents.get(name);
    }

    public final void registerNamedComponentRegistry(ComponentRegistry componentRegistry, String name) {
        this.namedComponents.put(name, componentRegistry);
    }

    public final void unregisterNamedComponentRegistry(String name) {
        this.namedComponents.remove(name);
    }

    public final void rewireNamedRegistries() {
        for (ComponentRegistry cr : this.namedComponents.values()) {
            cr.rewire();
        }
    }

    public Map<Byte, ModuleCommandInitializer> getModuleCommandInitializers() {
        return this.moduleProperties.moduleCommandInitializers();
    }

    @Override
    public void start() {
        try {
            boolean needToNotify;
            boolean bl = needToNotify = this.state != ComponentStatus.RUNNING && this.state != ComponentStatus.INITIALIZING;
            if (needToNotify) {
                for (ModuleLifecycle l : this.moduleLifecycles) {
                    l.cacheManagerStarting(this, this.globalConfiguration);
                }
            }
            super.start();
            if (!versionLogged) {
                log.version(Version.printVersion());
                versionLogged = true;
            }
            if (needToNotify && this.state == ComponentStatus.RUNNING) {
                for (ModuleLifecycle l : this.moduleLifecycles) {
                    l.cacheManagerStarted(this);
                }
            }
        }
        catch (RuntimeException rte) {
            block10: {
                try {
                    this.resetVolatileComponents();
                    this.rewire();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Unable to reset GlobalComponentRegistry after a failed restart!", e);
                        break block10;
                    }
                    log.warn("Unable to reset GlobalComponentRegistry after a failed restart due to an exception of type " + e.getClass().getSimpleName() + " with message " + e.getMessage() + ". Use DEBUG level logging for full exception details.");
                }
            }
            throw new EmbeddedCacheManagerStartupException(rte);
        }
    }

    @Override
    public void stop() {
        boolean needToNotify;
        boolean bl = needToNotify = this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING;
        if (needToNotify) {
            for (ModuleLifecycle l : this.moduleLifecycles) {
                l.cacheManagerStopping(this);
            }
        }
        super.stop();
        if (this.state == ComponentStatus.TERMINATED && needToNotify) {
            for (ModuleLifecycle l : this.moduleLifecycles) {
                l.cacheManagerStopped(this);
            }
        }
    }

    public final GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public boolean removeCache(String cacheName) {
        return this.createdCaches.remove(cacheName);
    }

    public ModuleProperties getModuleProperties() {
        return this.moduleProperties;
    }
}

