/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.ReplicationInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedReplicationInterceptor
extends ReplicationInterceptor {
    private static final Log log = LogFactory.getLog(VersionedReplicationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected PrepareCommand buildPrepareCommandForResend(TxInvocationContext ctx, CommitCommand commit) {
        VersionedPrepareCommand command = this.cf.buildVersionedPrepareCommand(commit.getGlobalTransaction(), ctx.getModifications(), true);
        super.buildPrepareCommandForResend(ctx, commit);
        EntryVersionsMap vs = new EntryVersionsMap();
        for (CacheEntry ce : ctx.getLookedUpEntries().values()) {
            vs.put(ce.getKey(), (IncrementableEntryVersion)ce.getVersion());
        }
        command.setVersionsSeen(vs);
        return command;
    }

    @Override
    protected void broadcastPrepare(TxInvocationContext context, PrepareCommand command) {
        if (!this.rpcManager.getTransport().isCoordinator()) {
            Map<Address, Response> resps = this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, true, true);
            Response r = resps.get(this.rpcManager.getTransport().getCoordinator());
            CacheTransaction ct = context.getCacheTransaction();
            if (r.isSuccessful()) {
                SuccessfulResponse sr = (SuccessfulResponse)r;
                EntryVersionsMap uv = (EntryVersionsMap)sr.getResponseValue();
                ct.setUpdatedEntryVersions(uv);
            }
        } else {
            super.broadcastPrepare(context, command);
        }
    }
}

