/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.infinispan.CacheException;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.container.EntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.util.TimSort;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OptimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    final LockAcquisitionVisitor lockAcquisitionVisitor = new LockAcquisitionVisitor();
    private static final MurmurHash3 HASH = new MurmurHash3();
    private static final Comparator<Object> keyComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int anotherVal;
            int thisVal = HASH.hash(o1);
            return thisVal < (anotherVal = HASH.hash(o2)) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    };
    EntryFactory entryFactory;
    private static final Log log = LogFactory.getLog(OptimisticLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void setDependencies(EntryFactory entryFactory) {
        this.entryFactory = entryFactory;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        this.abortIfRemoteTransactionInvalid(ctx, command);
        if (!command.hasModifications() || command.writesToASingleKey()) {
            log.trace("Not using lock reordering as we have a single key.");
            this.acquireLocksVisitingCommands(ctx, command);
        } else {
            boolean hasClear;
            Object[] orderedKeys = this.sort(command.getModifications());
            boolean bl = hasClear = orderedKeys == null;
            if (hasClear) {
                log.trace("Not using lock reordering as the prepare contains a clear command.");
                this.acquireLocksVisitingCommands(ctx, command);
            } else {
                log.tracef("Using lock reordering, order is: %s", orderedKeys);
                this.acquireAllLocks(ctx, orderedKeys);
                ctx.addAllAffectedKeys(Arrays.asList(orderedKeys));
            }
        }
        return this.invokeNextAndCommitIf1Pc(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            for (Object key : this.dataContainer.keySet()) {
                this.entryFactory.wrapEntryForClear(ctx, key);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new CacheException("Explicit locking is not allowed with optimistic caches!");
    }

    private Object[] sort(WriteCommand[] writes) {
        HashSet<Object> set = new HashSet<Object>();
        block6: for (WriteCommand wc : writes) {
            switch (wc.getCommandId()) {
                case 5: {
                    return null;
                }
                case 8: 
                case 10: 
                case 11: {
                    set.add(((DataWriteCommand)wc).getKey());
                    continue block6;
                }
                case 9: {
                    set.addAll(wc.getAffectedKeys());
                    continue block6;
                }
                case 25: {
                    ApplyDeltaCommand command = (ApplyDeltaCommand)wc;
                    if (!this.cdl.localNodeIsOwner(command.getKey())) continue block6;
                    Object[] compositeKeys = command.getCompositeKeys();
                    set.addAll(Arrays.asList(compositeKeys));
                }
            }
        }
        Object[] sorted = set.toArray(new Object[set.size()]);
        TimSort.sort(sorted, keyComparator);
        return sorted;
    }

    private void acquireAllLocks(TxInvocationContext ctx, Object[] orderedKeys) throws InterruptedException {
        for (Object key : orderedKeys) {
            this.lockAndRegisterBackupLock(ctx, key);
        }
    }

    private void acquireLocksVisitingCommands(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        for (WriteCommand wc : command.getModifications()) {
            wc.acceptVisitor(ctx, this.lockAcquisitionVisitor);
        }
    }

    private final class LockAcquisitionVisitor
    extends AbstractVisitor {
        private LockAcquisitionVisitor() {
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            for (Object key : OptimisticLockingInterceptor.this.dataContainer.keySet()) {
                OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key);
                txC.addAffectedKey(key);
            }
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            for (Object key : command.getMap().keySet()) {
                OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key);
                txC.addAffectedKey(key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, command.getKey());
            txC.addAffectedKey(command.getKey());
            return null;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, command.getKey());
            txC.addAffectedKey(command.getKey());
            return null;
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (OptimisticLockingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                Object[] compositeKeys;
                for (Object key : compositeKeys = command.getCompositeKeys()) {
                    OptimisticLockingInterceptor.this.lockAndRegisterBackupLock((TxInvocationContext)ctx, key);
                }
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, command.getKey());
            txC.addAffectedKey(command.getKey());
            return null;
        }
    }
}

